using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using OFW.ErrorHandler;
namespace OFW.Database
{
    /// <summary>
    /// ڑÕbZ[Wgݗ
    /// </summary>
    public class ConnectionExceptionMessageBuilder : ErrorMessageBuilder
    {
        /// <summary>
        /// PɉʂȂǂɕ\邽߂̃bZ[W\z
        /// </summary>
        /// <returns>\bZ[W</returns>
        public override string BuildMessage()
        {
            return mException.Message;

        }

        /// <summary>
        /// OȂǂɏo͂邽߂̃bZ[W\z
        /// </summary>
        /// <returns>o̓bZ[W</returns>
        public override string BuildLogMessage()
        {
            string msg = "";
            StringBuilder msgBuilder = new StringBuilder();
            //SQLG[ɃLXg
            ConnectionException ex = (ConnectionException)mException;
            //Kvȏgݗ
            //1){̏
            msgBuilder.AppendLine(this.BuildMessage());
            //Kvȏgݗ
            msgBuilder.Append("SERVER=" + ex.Server);
            msgBuilder.Append(" STATE=" + ex.State);
            msgBuilder.Append(" NUMBER =" + ex.ErrorNumber);
            msgBuilder.Append(" AT " + ex.Procedure + " LINE =" + ex.LineNumber.ToString());
            msgBuilder.AppendLine("");

            foreach (Command c in ex.Commands)
            {
                msgBuilder.Append("command text=");
                msgBuilder.AppendLine(c.Text);
                foreach (Parameter p in c.Parameters)
                {
                    msgBuilder.Append("parameter ");
                    msgBuilder.Append(p.ParameterName);
                    msgBuilder.Append("(");
                    msgBuilder.Append(p.ParameterType.ToString());
                    msgBuilder.Append(")");
                    msgBuilder.Append(" = ");
                    msgBuilder.Append(OFW.Util.StringUtil.StringValue(p.ParameterValue));

                    msgBuilder.AppendLine("");

                }
            }
            msg = msgBuilder.ToString();
            return msg;
        }
        /// <summary>
        /// bZ[WXMLm[hƂĐ
        /// </summary>
        /// <returns></returns>
        public override System.Xml.XmlNode BuildMessageAsXmlNode()
        {
            //SQLG[ɃLXg
            ConnectionException ex = mException as ConnectionException;

            //{(O^CvAbZ[WAX^bNg[X)
            XmlNode node = base.BuildMessageAsXmlNode();

            XmlElement element = node.OwnerDocument.CreateElement("server");
            XmlText text = node.OwnerDocument.CreateTextNode(ex.Server);
            element.AppendChild(text);
            node.AppendChild(element);

            element = node.OwnerDocument.CreateElement("state");
            text = node.OwnerDocument.CreateTextNode(ex.State.ToString());
            element.AppendChild(text);
            node.AppendChild(element);

            element = node.OwnerDocument.CreateElement("errorNumber");
            text = node.OwnerDocument.CreateTextNode(ex.ErrorNumber.ToString());
            element.AppendChild(text);
            node.AppendChild(element);

            element = node.OwnerDocument.CreateElement("procedure");
            text = node.OwnerDocument.CreateTextNode(ex.Procedure);
            element.AppendChild(text);
            node.AppendChild(element);

            element = node.OwnerDocument.CreateElement("lineNumber");
            text = node.OwnerDocument.CreateTextNode(ex.LineNumber.ToString());
            element.AppendChild(text);
            node.AppendChild(element);

            return node;
        }
    }
}
