using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using OFW.Util;
using OFW.FieldProperties;
using OFW.Database;

namespace OFW.Acl.Models.Base
{
    /// <summary>
    /// table acl_rules Field`
    /// </summary>
    [Serializable()]
    public class AclRulesTableRow : OFW.Models.Entity,ICloneable
    {
        ///<summary>[id]</summary>
        protected Int32 _id;
        ///<summary>[id]</summary>
        public Int32 id{
            get{return _id;}
            set{_id = value;}
        }
        ///<summary>[resource_id]</summary>
        protected Int32 _resourceId;
        ///<summary>[resource_id]</summary>
        public Int32 resourceId{
            get{return _resourceId;}
            set{_resourceId = value;}
        }
        ///<summary>[role_id]</summary>
        protected Int32 _roleId;
        ///<summary>[role_id]</summary>
        public Int32 roleId{
            get{return _roleId;}
            set{_roleId = value;}
        }
        ///<summary>[allow_create]</summary>
        protected Int32 _allowCreate;
        ///<summary>[allow_create]</summary>
        public Int32 allowCreate{
            get{return _allowCreate;}
            set{_allowCreate = value;}
        }
        ///<summary>[allow_read]</summary>
        protected Int32 _allowRead;
        ///<summary>[allow_read]</summary>
        public Int32 allowRead{
            get{return _allowRead;}
            set{_allowRead = value;}
        }
        ///<summary>[allow_update]</summary>
        protected Int32 _allowUpdate;
        ///<summary>[allow_update]</summary>
        public Int32 allowUpdate{
            get{return _allowUpdate;}
            set{_allowUpdate = value;}
        }
        ///<summary>[allow_delete]</summary>
        protected Int32 _allowDelete;
        ///<summary>[allow_delete]</summary>
        public Int32 allowDelete{
            get{return _allowDelete;}
            set{_allowDelete = value;}
        }
        ///<summary>[description]</summary>
        protected string _description;
        ///<summary>[description]</summary>
        public string description{
            get{return _description;}
            set{_description = value;}
        }
        ///<summary>[deleted]</summary>
        protected Int32 _deleted;
        ///<summary>[deleted]</summary>
        public Int32 deleted{
            get{return _deleted;}
            set{_deleted = value;}
        }
        ///<summary>[created_at]</summary>
        protected object _createdAt;
        ///<summary>[created_at]</summary>
        public object createdAt{
            get{return _createdAt;}
            set{_createdAt = value;}
        }
        ///<summary>[modified_at]</summary>
        protected object _modifiedAt;
        ///<summary>[modified_at]</summary>
        public object modifiedAt{
            get{return _modifiedAt;}
            set{_modifiedAt = value;}
        }
        
        /// <summary>
        /// default construct 
        /// </summary>
        public AclRulesTableRow() : base()
        {
            this._id = 0;
            this._resourceId = 0;
            this._roleId = 0;
            this._allowCreate = 0;
            this._allowRead = 0;
            this._allowUpdate = 0;
            this._allowDelete = 0;
            this._description = "";
            this._deleted = 0;
            this._createdAt = null;
            this._modifiedAt = null;
            
        }
        
        /// <summary>
        /// 񖼂w肵Ēlݒ
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value">l</param>
        public override void SetValue(string name,object value)
        {
            if(name ==  "id"){ this._id = NumberUtil.Value<Int32>( value );return; }
            if(name ==  "resource_id"){ this._resourceId = NumberUtil.Value<Int32>( value );return; }
            if(name ==  "role_id"){ this._roleId = NumberUtil.Value<Int32>( value );return; }
            if(name ==  "allow_create"){ this._allowCreate = NumberUtil.Value<Int32>( value );return; }
            if(name ==  "allow_read"){ this._allowRead = NumberUtil.Value<Int32>( value );return; }
            if(name ==  "allow_update"){ this._allowUpdate = NumberUtil.Value<Int32>( value );return; }
            if(name ==  "allow_delete"){ this._allowDelete = NumberUtil.Value<Int32>( value );return; }
            if(name ==  "description"){ this._description = StringUtil.StringValue( value );return; }
            if(name ==  "deleted"){ this._deleted = NumberUtil.Value<Int32>( value );return; }
            if(name ==  "created_at"){ this._createdAt = DateUtil.DateValue( value );return; }
            if(name ==  "modified_at"){ this._modifiedAt = DateUtil.DateValue( value );return; }
            
        }
        /// <summary>
        /// 񖼂w肵Ēl擾
        /// </summary>
        /// <param name="name"></param>
        public override object GetValue(string name)
        {
            if(name ==  "id") return this._id;
            if(name ==  "resource_id") return this._resourceId;
            if(name ==  "role_id") return this._roleId;
            if(name ==  "allow_create") return this._allowCreate;
            if(name ==  "allow_read") return this._allowRead;
            if(name ==  "allow_update") return this._allowUpdate;
            if(name ==  "allow_delete") return this._allowDelete;
            if(name ==  "description") return this._description;
            if(name ==  "deleted") return this._deleted;
            if(name ==  "created_at") return this._createdAt;
            if(name ==  "modified_at") return this._modifiedAt;
            
            return null;
        }
        
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual object Clone()
        {
            AclRulesTableRow clone = new AclRulesTableRow();
            clone.CopyFrom(this);
            return clone;
        }
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual void CopyFrom(AclRulesTableRow source)
        {
            this.id = source.id;
            this.resourceId = source.resourceId;
            this.roleId = source.roleId;
            this.allowCreate = source.allowCreate;
            this.allowRead = source.allowRead;
            this.allowUpdate = source.allowUpdate;
            this.allowDelete = source.allowDelete;
            this.description = source.description;
            this.deleted = source.deleted;
            this.createdAt = source.createdAt;
            this.modifiedAt = source.modifiedAt;
            
            
            this.IsNew = source.IsNew;
            this.IsModified = source.IsModified;
            this.IsDeleted = source.IsDeleted;
            
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        public override void Map(DataRow row)
        {
            DataColumnCollection cols = row.Table.Columns;
            if (cols.Contains("id")){ this._id = NumberUtil.Value<Int32>(row["id"]); }
            if (cols.Contains("resource_id")){ this._resourceId = NumberUtil.Value<Int32>(row["resource_id"]); }
            if (cols.Contains("role_id")){ this._roleId = NumberUtil.Value<Int32>(row["role_id"]); }
            if (cols.Contains("allow_create")){ this._allowCreate = NumberUtil.Value<Int32>(row["allow_create"]); }
            if (cols.Contains("allow_read")){ this._allowRead = NumberUtil.Value<Int32>(row["allow_read"]); }
            if (cols.Contains("allow_update")){ this._allowUpdate = NumberUtil.Value<Int32>(row["allow_update"]); }
            if (cols.Contains("allow_delete")){ this._allowDelete = NumberUtil.Value<Int32>(row["allow_delete"]); }
            if (cols.Contains("description")){ this._description = StringUtil.StringValue(row["description"]); }
            if (cols.Contains("deleted")){ this._deleted = NumberUtil.Value<Int32>(row["deleted"]); }
            if (cols.Contains("created_at")){ this._createdAt = DateUtil.DateValue(row["created_at"]); }
            if (cols.Contains("modified_at")){ this._modifiedAt = DateUtil.DateValue(row["modified_at"]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        /// <param name="alias">Iɂʖ̃vtBbNX</param>
        public override void Map(DataRow row,string alias)
        {
            DataColumnCollection cols = row.Table.Columns;
            if (cols.Contains(alias + "__id")){ this._id = NumberUtil.Value<Int32>(row[alias + "__id"]); }
            if (cols.Contains(alias + "__resource_id")){ this._resourceId = NumberUtil.Value<Int32>(row[alias + "__resource_id"]); }
            if (cols.Contains(alias + "__role_id")){ this._roleId = NumberUtil.Value<Int32>(row[alias + "__role_id"]); }
            if (cols.Contains(alias + "__allow_create")){ this._allowCreate = NumberUtil.Value<Int32>(row[alias + "__allow_create"]); }
            if (cols.Contains(alias + "__allow_read")){ this._allowRead = NumberUtil.Value<Int32>(row[alias + "__allow_read"]); }
            if (cols.Contains(alias + "__allow_update")){ this._allowUpdate = NumberUtil.Value<Int32>(row[alias + "__allow_update"]); }
            if (cols.Contains(alias + "__allow_delete")){ this._allowDelete = NumberUtil.Value<Int32>(row[alias + "__allow_delete"]); }
            if (cols.Contains(alias + "__description")){ this._description = StringUtil.StringValue(row[alias + "__description"]); }
            if (cols.Contains(alias + "__deleted")){ this._deleted = NumberUtil.Value<Int32>(row[alias + "__deleted"]); }
            if (cols.Contains(alias + "__created_at")){ this._createdAt = DateUtil.DateValue(row[alias + "__created_at"]); }
            if (cols.Contains(alias + "__modified_at")){ this._modifiedAt = DateUtil.DateValue(row[alias + "__modified_at"]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataReader炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="reader">ǂݍ񂾃[_[</param>
        /// <remarks>DataReader̐Ãe[uŝ̗݂̒`ƓőÎݗL</remarks>
        public override void Map(IDataReader reader)
        {
            this._id = NumberUtil.Value<Int32>(reader[0]);
            this._resourceId = NumberUtil.Value<Int32>(reader[1]);
            this._roleId = NumberUtil.Value<Int32>(reader[2]);
            this._allowCreate = NumberUtil.Value<Int32>(reader[3]);
            this._allowRead = NumberUtil.Value<Int32>(reader[4]);
            this._allowUpdate = NumberUtil.Value<Int32>(reader[5]);
            this._allowDelete = NumberUtil.Value<Int32>(reader[6]);
            this._description = StringUtil.StringValue(reader[7]);
            this._deleted = NumberUtil.Value<Int32>(reader[8]);
            this._createdAt = DateUtil.DateValue(reader[9]);
            this._modifiedAt = DateUtil.DateValue(reader[10]);
            
            this.IsNew = false;
        }
    }

}