using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using OFW.Util;
using OFW.FieldProperties;
using OFW.Database;

namespace OFW.Acl.Models 
{
    /// <summary>
    /// AclRoles f`
    /// </summary>
    [Serializable()]
    public class AclRolesModel : TreeDataAccess<AclRolesEntity, AclRolesProperty>
	{
        /// <summary>
        /// default construct  
        /// </summary>
        public AclRolesModel() : base()
        {
        }
        /// <summary>
        /// ̐ڑgp\z
        /// </summary>
        /// <param name="connection">̐ڑBJĂO</param>
        public AclRolesModel(Connection connection) : base(connection)
        {
        }
        /// <summary>
        /// [U[ɕRt[̎擾
        /// </summary>
        /// <param name="userId">[U[ʂID</param>
        /// <returns>[U[ɕRt[</returns>
        public List<IAclRole> findByUser(string userId)
        {
            List<IAclRole> roles = new List<IAclRole>();
            try
            {
                this.connect();
                string query = @"select acl_roles.* from acl_roles
inner join auth_users_roles 
on acl_roles.id  = auth_users_roles.acl_roles_id
where auth_users_roles.login_id = @user_id
order by acl_roles_id";

                Command command = new Command(query, System.Data.CommandType.Text);
                command.SetParameter(new Parameter("@user_id", DbType.String, userId));
                using (DataSet result = connection.ExecuteQuery(command))
                {
                    foreach (DataRow row in result.Tables[0].Rows)
                    {
                        AclRolesEntity entity = new AclRolesEntity();
                        entity.Map(row);
                        roles.Add(entity);
                    }
                }

                return roles;
            }
            finally
            {
                this.disconnect();
            }
        }
        /// <summary>
        /// idZbg
        /// </summary>
        /// <param name="node"></param>
        protected override void setupId(ref AclRolesEntity node)
        {
            string query = @"
if exists( select * from acl_roles where name = @name ) begin
    select id from acl_roles where name = @name
end
else begin
    select isnull(max(id),0) + 1 from acl_roles
end
";
            Command command = new Command(query);
            command.SetParameter(new Parameter("@name",node.name));
            int newId = NumberUtil.Value<int>(connection.ExecuteScalar(command));
            node.id = newId;
            node.deleted = 0;
        }
        /// <summary>
        /// ̎w
        /// </summary>
        /// <param name="name">[</param>
        /// <returns>[</returns>
        public IAclRole findByName(string name)
        {
            AclRolesEntity roles = null;
            try
            {
                this.connect();
                string query = @"select acl_roles.* from acl_roles
where name = @name";

                Command command = new Command(query, System.Data.CommandType.Text);
                command.SetParameter(new Parameter("@name", DbType.String, name));
                using (DataSet result = connection.ExecuteQuery(command))
                {
                    foreach (DataRow row in result.Tables[0].Rows)
                    {
                        AclRolesEntity entity = new AclRolesEntity();
                        entity.Map(row);
                        roles = entity;
                    }
                }

                return roles;
            }
            finally
            {
                this.disconnect();
            }
        }

    }

}