package jp.sourceforge.observoice.service;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;

import jp.sourceforge.observoice.dao.CommentDao;
import jp.sourceforge.observoice.entity.Comment;

import org.seasar.framework.container.annotation.tiger.Binding;

public class CommentService {

    @Binding
    CommentDao commentDao;

    public Comment postComment(String userId, int type, String content) {
        Comment c = new Comment();
        c.userId = userId;
        c.type = type;
        c.content = content;
        c.created = new Date();

        commentDao.insert(c);

        return c;
    }

    public List<Comment> getComments(int courseId, Date since, Date until,
            int count) {
        Timestamp s = since == null ? null : new Timestamp(since.getTime());
        Timestamp u = until == null ? null : new Timestamp(until.getTime());
        if (s != null && u != null) {
            return commentDao.selectByCourseIdBetween(courseId, s, u, count);
        } else if (s != null) {
            return commentDao.selectByCourseIdAfter(courseId, s, count);
        } else if (u != null) {
            return commentDao.selectByCourseIdBefore(courseId, u, count);
        } else {
            return commentDao.selectByCourseId(courseId, count);
        }
    }

    public long getCommentCount(int courseId) {
        return commentDao.countByCourseId(courseId);
    }

}
