package jp.sourceforge.observoice.network.task;

import jp.sourceforge.observoice.network.requestmethod.ObsvRequestMethod;
import jp.sourceforge.observoice.network.requestmethod.GetLectureInfoMethod;

/**
 * 講義情報取得操作を表す
 * 
 * @author rtakizawa
 */
public class GetLectureInfoTask extends ObsvNetworkTask {

    private String courceId;

    /**
     * @param courceId 講義ID
     */
    public GetLectureInfoTask(String courceId) {
        this.courceId = courceId;
    }

    @Override
    protected ObsvRequestMethod createRequestMethod() {
        return new GetLectureInfoMethod(courceId);
    }

}
