package jp.sourceforge.observoice.network.task;

import jp.sourceforge.observoice.network.requestmethod.ObsvRequestMethod;
import jp.sourceforge.observoice.network.requestmethod.GetLectureInfoListMethod;

/**
 * 講義情報リスト取得操作を表す
 * 
 * @author rtakizawa
 */
public class GetLectureInfoListTask extends ObsvNetworkTask {

    private int count;
    private String day;
    private int period;
    private String q;

    /**
     * @param count 取得する講義情報の件数
     * @param day 曜日
     * @param period 時限
     * @param q 検索文字列
     */
    public GetLectureInfoListTask(int count, String day, int period, String q) {
        this.count = count;
        this.day = day;
        this.period = period;
        this.q = q;
    }

    @Override
    protected ObsvRequestMethod createRequestMethod() {
        return new GetLectureInfoListMethod(count, day, period, q);
    }

}
