package jp.sourceforge.observoice.network.response;

import org.json.JSONObject;
import org.json.JSONException;

/**
 * Observoiceサーバから返ってくるレスポンスを表すクラス。
 * サーバAPIとの依存部分をこのクラス(および子クラス)にまとめる。
 * 
 * @author rtakizawa
 */
public abstract class ObsvResponseObject {
    
    // JSON作成失敗時のエラーメッセージ
    final static protected String jsonErrorMessage = "JSONException: サーバからのレスポンスがおかしいよ";

    // サーバからのレスポンス文字列
    protected String response;
    // サーバからのレスポンスを表すJSONオブジェクト
    protected JSONObject json;

    protected ObsvResponseObject(String response) {
        this.response = response;
        this.json = null;
        if (response != null) {
            try {
                this.json = new JSONObject(response);
                if (!json.has("status")) {
                    // 正常なレスポンスであることを表す
                    json.put("status", 0);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * レスポンスに対応するJSON文字列を返す
     * 
     * @return JSON文字列
     */
    public String toString() {
        String res;
        
        if (!isCorrectResponse()) {
            return getErrorMessage();
        }
        
        try {
            res = json.toString(4);
        } catch (JSONException e) {
            e.printStackTrace();
            return jsonErrorMessage;
        }
        return res;
    }
    
    /**
     * 正しいレスポンスか
     * 
     * @return
     */
    public boolean isCorrectResponse() {
        if (json == null) {
            return false;
        }
        try {
            if (json.getInt("status") < 0) {
                return false;
            }
            else {
                return true;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }
    
    /**
     * 不正なレスポンスに対するエラーメッセージ
     * 
     * @return
     */
    private String getErrorMessage() {
        try {
            return json.getString("error");
        }
        catch (JSONException e) {
            return jsonErrorMessage;
        }
    }

}
