package jp.sourceforge.observoice.network.requestmethod;

import jp.sourceforge.observoice.network.response.ObsvResponseObject;

/**
 * Observoiceのクライアントからサーバーへ送信するリクエストメソッドデータのインターフェース。
 * 
 * @author rtakizawa
 */
public interface ObsvRequestMethod {

    /**
     * サーバのホスト名 (テストするときはここ適宜いじってくだしあ)
     */
    public static final String hostName = "192.168.11.3:8080";

    /**
     * Observoiceリクエストメソッドの送信
     * 
     * @return サーバーからのレスポンスオブジェクト
     */
    public ObsvResponseObject send() throws Exception;

    /**
     * リクエストメソッドを送信する対象URL文字列を生成
     * 
     * @return　URL文字列
     */
    public String createUrlString();

    /**
     * リクエストメソッドに対応するレスポンスオブジェクトを生成
     * 
     * @param resJson レスポンスのJSONオブジェクト
     * 
     * @return レスポンスオブジェクト
     */
    public ObsvResponseObject createResponseObject(String response);

}
