package jp.sourceforge.observoice.network.requestmethod;

import org.json.JSONObject;
import org.json.JSONException;

import jp.sourceforge.observoice.network.response.LoginResponse;
import jp.sourceforge.observoice.network.response.ObsvResponseObject;

/**
 * ログインを要求するリクエストメソッド
 * 
 * @author rtakizawa
 */
public class LoginMethod extends ObsvPostRequestMethod {

    private String user_id;
    private int lecture_id;

    public LoginMethod(String user_id, int lecture_id) {
        this.name = "login";
        this.user_id = user_id;
        this.lecture_id = lecture_id;
    }

    /**
     * リクエストメソッドに対応するJSONオブジェクトを生成
     * 
     * @return リクエストメソッドに対応するJSONオブジェクト JSONオブジェクトの生成に失敗した場合はnull
     */
    protected JSONObject createJson() {
        JSONObject json = new JSONObject();
        try {
            json.put("method", name);
            json.put("user_id", user_id);
            json.put("lecture_id", lecture_id);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return json;
    }

    /**
     * リクエストメソッドに対応するURL文字列を生成
     */
    public String createUrlString() {
        // example
        return "http://" + hostName + "/login";
    }

    /**
     * サーバからのレスポンスからレスポンスオブジェクトを生成。
     */
    public ObsvResponseObject createResponseObject(String response) {
        return new LoginResponse(response);
    }
}
