package jp.sourceforge.observoice.network.requestmethod;

import jp.sourceforge.observoice.network.response.ObsvResponseObject;
import jp.sourceforge.observoice.network.response.GetLectureInfoResponse;

/**
 * 講義情報取得メソッド
 * 
 * @author rtakizawa
 */
public class GetLectureInfoMethod extends ObsvGetRequestMethod {

    String courceId;

    /**
     * @param courceId 講義ID
     */
    public GetLectureInfoMethod(String courceId) {
        this.courceId = courceId;
    }

    @Override
    public String createUrlString() {
        return "http://" + hostName + "/api/courses/" + courceId + ".json";
    }

    @Override
    public ObsvResponseObject createResponseObject(String response) {
        return new GetLectureInfoResponse(response);
    }

}
