package jp.sourceforge.observoice.network.requestmethod;

import java.util.Calendar;
import java.text.SimpleDateFormat;
import jp.sourceforge.observoice.network.response.GetCommentListResponse;
import jp.sourceforge.observoice.network.response.ObsvResponseObject;

/**
 * コメント一覧取得を要求するリクエストメソッド
 * 
 * @author rtakizawa
 */
public class GetCommentListMethod extends ObsvGetRequestMethod {

    private String courceId;
    private int count;
    private String since, until;

    /**
     * @param courceId 講義ID
     * @param count 取得するコメントの件数
     * @param since この日付以降のコメントを取得
     * @param until この日付以前のコメントを取得
     */
    public GetCommentListMethod(String courceId, int count, Calendar since,
            Calendar until) {
        this.courceId = courceId;
        this.count = count;
        this.since = (new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z"))
                .format(since.getTime());
        this.until = (new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z"))
                .format(until.getTime());
    }

    public String createUrlString() {
        // うーｎ
        String url = "http://" + hostName + "/api/courses/" + courceId
                + "/comments.json?" + "count=" + count + "&since=" + since
                + "&until=" + until;
        url = url.replaceAll(" ", "%20");
        return url;
    }

    public ObsvResponseObject createResponseObject(String response) {
        return new GetCommentListResponse(response);
    }

}
