package jp.sourceforge.observoice.network;

import java.io.PrintStream;
import java.io.InputStreamReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * サーバーとのHTTP通信を担当する
 * 
 * @author rtakizawa
 */
public class HttpClient {

    /**
     * サーバ接続のタイムアウト(msec)
     */
    private final static int timeout = 7000;

    /**
     * サーバにGETメソッドを送信してレスポンスを返す
     * 
     * @param urlStr
     * @return
     * @throws IOException
     */
    public String get(String urlStr) throws IOException {
        return request("GET", urlStr, null);
    }

    /**
     * サーバにPOSTメソッドを送信してレスポンスを返す
     * 
     * @param urlStr
     * @param param
     * @return
     * @throws IOException
     */
    public String post(String urlStr, String param) throws IOException {
        return request("POST", urlStr, param);
    }

    /**
     * サーバにリクエストを送信してレスポンスを返す
     * 
     * @param method リクエストメソッドの種類
     * @param urlStr URL文字列
     * @param param POSTリクエストパラメータ
     * 
     * @return サーバーからのレスポンス文字列 あるいはエラー時のJSON文字列
     * @throws IOException
     * 
     */
    private String request(String method, String urlStr, String param)
            throws IOException {
        // methodが正しいかチェック
        if (method != "POST" && method != "GET") {
            return createErrorResponse(-1,
                    "Request method error: リクエストメソッドがただしくないよ");
        }

        StringBuffer resBuff = new StringBuffer();
        URL url = new URL(urlStr);

        HttpURLConnection con = (HttpURLConnection) url.openConnection();

        con.setRequestMethod(method);
        con.setConnectTimeout(timeout);

        con.setRequestProperty("User-Agent", "Observoice Client");
        con.setRequestProperty("Accept-Language", "ja");
        if (method == "POST") {
            con.setRequestProperty("Content-type", "applications/json");
        }

        con.connect();
        if (con.getResponseCode() != HttpURLConnection.HTTP_OK) {
            return createErrorResponse(-1, "Connection Error: 接続できないよ");
        }

        if (method == "POST") {
            /* post用のPrintStream */
            PrintStream ps = new PrintStream(con.getOutputStream());
            /* postデータ送信 */
            ps.print(param);
            ps.close();
        }

        /* reponse受信用ストリーム */
        BufferedReader br = new BufferedReader(new InputStreamReader(
                con.getInputStream()));
        /* reponse取得 */
        String line = br.readLine();
        while (line != null) {
            resBuff.append(line);
            line = br.readLine();
        }
        br.close();

        return resBuff.toString();
    }

    private String createErrorResponse(int status, String message) {
        return "{\"status\":" + status + ", \"error\":\"" + message + "\"}";
    }

}
