package jp.sourceforge.observoice;

import android.app.Activity;
import android.os.Bundle;
import android.widget.TextView;
import android.widget.Button;
import android.view.View;
import jp.sourceforge.observoice.R;
import jp.sourceforge.observoice.network.response.ObsvResponseObject;
import jp.sourceforge.observoice.network.task.ObsvNetworkListener;
import jp.sourceforge.observoice.network.task.ObsvNetworkTask;
import jp.sourceforge.observoice.network.task.GetLectureInfoListTask;
import jp.sourceforge.observoice.network.task.GetCommentListTask;
import jp.sourceforge.observoice.network.task.GetLectureInfoTask;
import jp.sourceforge.observoice.network.task.PostCommentTask;

/**
 * JSONデータのやり取りをアクティビティ上でやる際のテスト用サンプル
 * 
 * @author rtakizawa
 */
public class ObservoiceNetworkingSampleActivity extends Activity {
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.main);

        final TextView textView = (TextView)findViewById(R.id.text);
        final Button button1 = (Button)findViewById(R.id.button1);
        final Button button2 = (Button)findViewById(R.id.button2);
        final Button button3 = (Button)findViewById(R.id.button3);
        final Button button4 = (Button)findViewById(R.id.button4);
        
        button1.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {
                // 講義情報一覧取得を表すオブジェクトを作成。
                ObsvNetworkTask getLectureInfos = new GetLectureInfoListTask(1, "月曜日", 7, "ソフトウェア");
                // 講義情報一覧取得後のUI更新処理を記述
                getLectureInfos.setListener(new ObsvNetworkListener() {
                    // responseがサーバからのレスポンスを表すオブジェクト
                    public void onSuccess(ObsvResponseObject response) {
                        String resStr = response.toString();
                        textView.setText(resStr);
                    }
                    // 例外系列
                    public void onFailure(Exception e) {
                        String errorMes = e.getMessage();
                        textView.setText(errorMes);
                    }
                });
                // 講義情報一覧取得タスク開始
                getLectureInfos.execute();
            }
        });
        
        button2.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {
                // コメント一覧取得を表すオブジェクトを作成
                ObsvNetworkTask getComments = new GetCommentListTask("courseIdExample");
                // コメント一覧取得を表すオブジェクト作成
                getComments.setListener(new ObsvNetworkListener() {
                    public void onSuccess(ObsvResponseObject response) {
                        String resStr = response.toString();
                        textView.setText(resStr);
                    }
                    
                    public void onFailure(Exception e) {
                        String errorMes = e.getMessage();
                        textView.setText(errorMes);
                    }
                });
                // コメント一覧取得タスク開始
                getComments.execute();
            }
        });
        
        button3.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {
                // 講義情報取得
                ObsvNetworkTask getLectureInfo = new GetLectureInfoTask("courseIdExample");
                getLectureInfo.setListener(new ObsvNetworkListener() {
                    public void onSuccess(ObsvResponseObject response) {
                        String resStr = response.toString();
                        textView.setText(resStr);
                    }
                    public void onFailure(Exception e) {
                        String errorMes = e.getMessage();
                        textView.setText(errorMes);
                    }
                });
                getLectureInfo.execute();
            }
        });
        
        button4.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {
                // コメント投稿タスク
                ObsvNetworkTask postComment = new PostCommentTask("12M34567", 1, "とりかわいい");
                postComment.setListener(new ObsvNetworkListener() {
                    public void onSuccess(ObsvResponseObject response) {
                        String resStr = response.toString();
                        textView.setText(resStr);
                    }
                    public void onFailure(Exception e) {
                        String errorMes = e.getMessage();
                        textView.setText(errorMes);
                    }
                });
                // ポストはテストサーバ側がまだ(というかめんどい…)なのでエラーがかえるよ
                postComment.execute();
            }
        });
    }
}