/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: linux_sigio.h,v 1.10 2003/12/06 06:18:55 hiro Exp $
 */

/*
 *  LINUX Υ֥åI/O ݡȥ⥸塼
 *
 *  Υ֥åI/O ݡȥ⥸塼ϡSIGIO ʥˤꡤ桼
 *  ϿХåؿƤӽФǽġ
 *
 *  SIGIO ʥˤꥳХåؿ¹ԤˤϡSIGIO 
 *  Υ٥ȥ֥åѰդ callback եɤ˥Х
 *  ؿarg եɤ˥ХåؿϤꤷ
 *  eneuque_sigioeb Ѥ SIGIO Υ٥ȥ塼Ͽ롥
 *
 *  ƤӽФ줿Хåؿ 0 ֤ȡϢ SIGIO Υ
 *  ȥ֥å ϥ塼Ͽ줿ޤޤȤʤꡤ³ SIGIO ʥ
 *  ƤƱ ХåؿƤӽФ롥Хåؿ 0 ʳ
 *  ֤ȡSIGIO Υ٥ȥ֥åϥ塼졤Х
 *  ؿϤʹ߸ƤӽФʤʤ롥
 */

#ifndef	_LINUX_SIGIO_H_
#define	_LINUX_SIGIO_H_

#ifdef __cplusplus
extern "C" {
#endif

/*
 *  SIGIO Υ٥ȥ֥å
 */
typedef BOOL	(*SIGIO_CBACK)(VP);	/* SIGIO Хåؿη */

typedef struct bsd_sigio_event_block {
	VP		queue[2];	/* SIGIO Υ٥ȥ塼ꥢ */
	SIGIO_CBACK	callback;	/* SIGIO Хåؿ */
	VP		arg;		/* ХåؿϤ */
} SIGIOEB;

/*
 *  SIGIO Υ٥ȥ֥åϿ
 */
extern ER	enqueue_sigioeb(SIGIOEB *sigioeb) throw();

/*
 *  ƥ൯ư SIGIO Υ٥ȥ֥åϿ
 */
extern ER	enqueue_sigioeb_initialize(SIGIOEB *sigioeb) throw();

/*
 *   Υ֥åI/O ⥸塼뵯ư롼
 */

extern void linux_sigio_initialize(VP_INT exinf) throw();

/*
 *  ߥϥɥΥ٥ֹ
 */
#define	INHNO_SIGIO	SIGIO

/*
 *  SIGIOߥϥɥ
 */

extern void linux_sigio_handler() throw();
    
/*
 * SIGIO
 */
#define LINUX_SIGIO_PRIORITY      2
#define LINUX_SIGIO_STACK_SIZE 8192

extern void linux_sigio_task(void) throw();

#ifdef __cplusplus
}
#endif

#endif /* _LINUX_SIGIO_H_ */
