/*****************************************************************************
 * FILE: ecrobot_interface.h
 *
 * COPYRIGHT 2007 Takashi Chikamasa <takashic@cybernet.co.jp>
 *
 * DESCRIPTION:
 *   This is a glue code to execute Embedded Coder Robot NXT generated code
 *   by using LEJOS NXJ. 
 *
 *   <About LEJOS NXJ>
 *    LEJOS NXJ is a full firmware replacement of LEGO Mindstorms NXT and 
 *   designed for Java programming environment for the NXT 
 *   ( For more detailed information, please see: http://lejos.sourceforge.net/ )
 *   In the LEJOS NXJ distribution, C source files for NXT platform layer is also
 *   included besides with the Java VM. The platform C source code is well
 *   structured, comprehensive, and achieved higher performance than the LEGO's
 *   one. Therefore, LEJOS NXJ (platform) is also the best GCC based C/C++  
 *   development platform for NXT.
 *
 *   The contents of this file are subject to the Mozilla Public License
 *   Version 1.0 (the "License"); you may not use this file except in
 *   compliance with the License. You may obtain a copy of the License at
 *   http://www.mozilla.org/MPL/
 *
 *   Software distributed under the License is distributed on an "AS IS"
 *   basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 *   License for the specific language governing rights and limitations
 *   under the License.
 *
 *   The Original Code is TinyVM code, first released March 6, 2000,
 *   later released as leJOS on September 23, 2000.
 *
 *   The Initial Developer of the Original Code is Jose H. Solorzano.
 *
 *   Contributor(s): see LEJOS NXJ ACKNOWLEDGEMENTS .
 *
 *****************************************************************************/
 
#ifndef _ECROBOT_INTERFACE_H_
#define _ECROBOT_INTERFACE_H_

/* LEJOS NXJ platform C */
#include "mytypes.h"
#include "interrupts.h"
#include "aic.h"
#include "AT91SAM7.h"
#include "uart.h"
#include "systick.h"
#include "nxt_avr.h"
#include "twi.h"
#include "platform_hooks.h"
#include "nxt_avr.h"
#include "nxt_lcd.h"
#include "nxt_motors.h"
#include "sensors.h"
#include "display.h"
#include "i2c.h"
#include "bt.h"

enum {
  ECROBOT_WAIT,
  ECROBOT_RUN,
  ECROBOT_EXIT
};

enum {
  NXT_PORT_A,
  NXT_PORT_B,
  NXT_PORT_C
};

enum {
  NXT_PORT_S1,
  NXT_PORT_S2,
  NXT_PORT_S3,
  NXT_PORT_S4
};

typedef struct {
  U32 battery_state;
  U8  buttons_state;
} nxt_inputs;

typedef struct {
  S8 speed;
  U8 mode;
} nxt_outputs;
  
#define BTN1 0x01
#define BTN2 0x02
#define BTN3 0x04
#define BTN4 0x08

#define ENTER_PRESSED BTN1
#define STOP_PRESSED  BTN2
#define RUN_PRESSED   BTN3
#define EXIT_PRESSED  BTN4

#define DEVICE_NO_INIT      0
#define DEVICE_INITIALIZED  1
#define BLUETOOTH_CONNECTED 2

#define N_BTN_STATE 10

#define INIT_EVENT    0x00000001

extern volatile U8 gDevice_status;

/* NXT servo motor API */
extern  S32 ecrobot_get_motor_rev(U8 port_id);
extern void ecrobot_set_motor_speed(U8 port_id, S8 speed);

/* NXT light sensor API */
extern  U16 ecrobot_get_light_sensor(U8 port_id);
extern void ecrobot_set_light_sensor_active(U8 port_id);
extern void ecrobot_set_light_sensor_inactive(U8 port_id);

/* NXT touch sensor API */
extern   U8 ecrobot_get_touch_sensor(U8 port_id);

/* NXT sound sensor API */
extern  U16 ecrobot_get_sound_sensor(U8 port_id);

/* NXT ultrasonic sensor API */
extern void ecrobot_init_sonar_sensor(U8 port_id);
extern  S32 ecrobot_get_sonar_sensor(U8 port_id);
extern void ecrobot_term_sonar_sensor(U8 port_id);

/* NXT Bluetooth API */
extern void ecrobot_init_bt_connection(void);
extern void ecrobot_send_bt_packet(U8 *buf, U32 bufLen);
extern  S32 ecrobot_read_bt_packet(U8 *buf, U32 bufLen);
extern void ecrobot_term_bt_connection(void);
extern void ecrobot_bt_data_logger(S8 data1, S8 data2);

/* NXT internal status API */
extern  U16 ecrobot_get_battery_voltage(void);
extern  U32 ecrobot_get_systick_ms(void);
extern   U8 ecrobot_get_button_state(void);
extern void ecrobot_poll_nxtstate(void);

/* LCD display command for debug */
extern void ecrobot_show_int(S32 var);
extern void ecrobot_debug1(unsigned int var1, unsigned int var2, unsigned int var3);
extern void ecrobot_debug2(unsigned int var1, unsigned int var2, unsigned int var3);
extern void ecrobot_status_monitor(void);

/* These extern declared parameter and functions are 
 * generated in ecrobot_main.c automatically
 */
extern const U8 target_subsystem_name[];
extern void ecrobot_device_initialize(void);
extern void ecrobot_device_terminate(void);
extern void ecrobot_main(U32 *inputs);

/* C interface for the system boot up assembly */
extern void start(void);

#endif
