/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt;

import lejos.nxt.I2CPort;
import lejos.nxt.LegacySensorPort;
import lejos.nxt.ListenerCaller;
import lejos.nxt.ListenerThread;
import lejos.nxt.SensorPortListener;

public class SensorPort
implements LegacySensorPort,
I2CPort,
ListenerCaller {
    private int iPortId;
    private short iNumListeners = 0;
    private SensorPortListener[] iListeners;
    private int iPreviousValue;
    private int type;
    private int mode;
    private static final byte[] powerType = new byte[]{0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1};
    private static final byte[] adType = new byte[]{-1, -1, -1, -1, -1, 1, 0, 1, 2, -1, -1, -1};
    public static final SensorPort S1 = new SensorPort(0);
    public static final SensorPort S2 = new SensorPort(1);
    public static final SensorPort S3 = new SensorPort(2);
    public static final SensorPort S4 = new SensorPort(3);
    public static final SensorPort[] PORTS = new SensorPort[]{S1, S2, S3, S4};

    public final int readRawValue() {
        return SensorPort.readSensorValue(this.iPortId, 0);
    }

    public final boolean readBooleanValue() {
        int rawValue = SensorPort.readSensorValue(this.iPortId, 0);
        return rawValue < 600;
    }

    private SensorPort(int aId) {
        this.iPortId = aId;
        this.type = 0;
        this.mode = 0;
    }

    public final int getId() {
        return this.iPortId;
    }

    public synchronized void addSensorPortListener(SensorPortListener aListener) {
        if (this.iListeners == null) {
            this.iListeners = new SensorPortListener[8];
        }
        short s = this.iNumListeners;
        this.iNumListeners = (short)(s + 1);
        this.iListeners[s] = aListener;
        ListenerThread.get().addSensorToMask(this.iPortId, this);
    }

    public final void activate() {
        this.setPowerType(1);
    }

    public final void passivate() {
        this.setPowerType(0);
    }

    public int getMode() {
        return this.mode;
    }

    public int getType() {
        return this.type;
    }

    public void setTypeAndMode(int type, int mode) {
        this.setType(type);
        this.setMode(mode);
    }

    public void setType(int type) {
        if (type < powerType.length) {
            this.type = type;
            byte adt = adType[type];
            this.setPowerType(powerType[type]);
            if (adt >= 0) {
                this.setADType(adt);
            }
        }
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int readValue() {
        int rawValue = SensorPort.readSensorValue(this.iPortId, 0);
        if (this.mode == 32) {
            return rawValue < 600 ? 1 : 0;
        }
        if (this.mode == 128) {
            return (1023 - rawValue) * 100 / 1023;
        }
        return rawValue;
    }

    static native int readSensorValue(int var0, int var1);

    private void setADType(int type) {
        SensorPort.setADTypeById(this.iPortId, type);
    }

    private void setPowerType(int type) {
        SensorPort.setPowerTypeById(this.iPortId, type);
    }

    static native void setADTypeById(int var0, int var1);

    static native void setPowerTypeById(int var0, int var1);

    public synchronized void callListeners() {
        int newValue = SensorPort.readSensorValue(this.iPortId, 0);
        for (int i = 0; i < this.iNumListeners; ++i) {
            this.iListeners[i].stateChanged(this, this.iPreviousValue, newValue);
        }
        this.iPreviousValue = newValue;
    }

    public static native void i2cEnableById(int var0);

    public static native void i2cDisableById(int var0);

    public static native int i2cBusyById(int var0);

    public static native int i2cStartById(int var0, int var1, int var2, int var3, byte[] var4, int var5, int var6);

    public void i2cEnable() {
        SensorPort.i2cEnableById(this.iPortId);
    }

    public void i2cDisable() {
        SensorPort.i2cDisableById(this.iPortId);
    }

    public int i2cBusy() {
        return SensorPort.i2cBusyById(this.iPortId);
    }

    public int i2cStart(int address, int internalAddress, int numInternalBytes, byte[] buffer, int numBytes, int transferType) {
        return SensorPort.i2cStartById(this.iPortId, address, internalAddress, numInternalBytes, buffer, numBytes, transferType);
    }
}

