/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt;

import lejos.nxt.ButtonListener;
import lejos.nxt.ListenerCaller;
import lejos.nxt.ListenerThread;
import lejos.nxt.Poll;

public class Button
implements ListenerCaller {
    public static final Button ENTER = new Button(1);
    public static final Button LEFT = new Button(2);
    public static final Button RIGHT = new Button(4);
    public static final Button ESCAPE = new Button(8);
    public static final Button[] BUTTONS = new Button[]{ENTER, LEFT, RIGHT, ESCAPE};
    private int iCode;
    private ButtonListener[] iListeners = new ButtonListener[4];
    private int iNumListeners;
    static Poll poller = new Poll();

    private Button(int aCode) {
        this.iCode = aCode;
    }

    public final int getId() {
        return this.iCode;
    }

    public final boolean isPressed() {
        return (Button.readButtons() & this.iCode) != 0;
    }

    public final void waitForPressAndRelease() throws InterruptedException {
        do {
            poller.poll(this.iCode << 4, 0);
        } while (this.isPressed());
    }

    public synchronized void addButtonListener(ButtonListener aListener) {
        if (this.iListeners == null) {
            this.iListeners = new ButtonListener[4];
        }
        this.iListeners[this.iNumListeners++] = aListener;
        ListenerThread.get().addButtonToMask(this.iCode, this);
    }

    public static native int readButtons();

    public synchronized void callListeners() {
        for (int i = 0; i < this.iNumListeners; ++i) {
            if (this.isPressed()) {
                this.iListeners[i].buttonPressed(this);
                continue;
            }
            this.iListeners[i].buttonReleased(this);
        }
    }
}

