/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class StringBuffer {
    char[] characters;
    int curPos = 0;
    private static final char[] numbers = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final float log10 = 2.3025851f;

    public StringBuffer() {
        this.characters = new char[0];
    }

    public StringBuffer(String aString) {
        this.characters = aString.toCharArray();
    }

    public StringBuffer(int length) {
        this.characters = new char[length];
    }

    public StringBuffer delete(int start, int end) {
        if (start >= 0 && start < end && start < this.curPos) {
            if (end >= this.curPos) {
                end = this.curPos;
            } else {
                System.arraycopy(this.characters, end, this.characters, start, this.curPos - end);
            }
            this.curPos -= end - start;
        }
        return this;
    }

    public StringBuffer append(String s) {
        char[] sc = s.toCharArray();
        int cl = this.characters.length;
        int sl = sc.length;
        char[] nc = this.characters;
        if (sl + this.curPos > cl) {
            nc = new char[sl + this.curPos];
            System.arraycopy(this.characters, 0, nc, 0, this.curPos);
        }
        System.arraycopy(sc, 0, nc, this.curPos, sl);
        this.characters = nc;
        this.curPos += sl;
        return this;
    }

    public StringBuffer append(Object aObject) {
        return this.append(aObject.toString());
    }

    public StringBuffer append(boolean aBoolean) {
        return this.append(aBoolean ? "true" : "false");
    }

    public StringBuffer append(char aChar) {
        return this.append(new String(new char[]{aChar}, 0, 1));
    }

    public StringBuffer append(int aInt) {
        if (aInt < 0) {
            this.characters[this.curPos++] = 45;
            aInt = -aInt;
        }
        int div = 0;
        for (int pow = (int)Math.floor(Math.log(aInt) / 2.3025851249694824); pow >= 0; --pow) {
            div = aInt / (int)Math.pow(10.0, pow);
            this.characters[this.curPos++] = numbers[div];
            aInt -= div * (int)Math.pow(10.0, pow);
        }
        return this;
    }

    public StringBuffer append(long aLong) {
        return this.append("<longs not supported>");
    }

    public StringBuffer append(float aFloat) {
        try {
            this.append(aFloat, 8);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.curPos = Math.min(this.characters.length, this.curPos);
        }
        return this;
    }

    public StringBuffer append(double aDouble) {
        try {
            this.append((float)aDouble, 8);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.curPos = Math.min(this.characters.length, this.curPos);
        }
        return this;
    }

    public String toString() {
        return new String(this.characters, 0, this.curPos);
    }

    public char charAt(int i) {
        return this.characters[i];
    }

    public int length() {
        return this.curPos;
    }

    public char[] getChars() {
        return this.characters;
    }

    private StringBuffer append(float number, int significantDigits) {
        if (number == 0.0f) {
            this.characters[this.curPos++] = 48;
            return this;
        }
        if (number < 0.0f) {
            this.characters[this.curPos++] = 45;
            number = -number;
        }
        int pow = (int)Math.floor(Math.log(number) / 2.3025851249694824);
        int exponent = 0;
        if (pow < -3 || pow > 6) {
            exponent = pow;
            number = (float)((double)number / Math.exp(2.30258509299405 * (double)exponent));
        }
        pow = (int)Math.floor(Math.log(number) / 2.3025851249694824);
        int insignificantDigits = -Math.min(0, pow);
        pow = Math.max(0, pow);
        double divisor = Math.pow(10.0, pow);
        int end = significantDigits + insignificantDigits;
        for (int i = 0; i < end; ++i) {
            int div;
            if (pow == -1) {
                this.characters[this.curPos++] = 46;
            }
            if ((div = (int)((double)number / divisor)) == 10) {
                this.characters[this.curPos++] = 49;
                this.characters[this.curPos++] = 48;
            } else {
                this.characters[this.curPos] = (char)(div + 48);
                ++this.curPos;
            }
            number = (float)((double)number - (double)div * divisor);
            --pow;
            if (number == 0.0f && (divisor /= 10.0) < 0.1) break;
        }
        while (this.characters[this.curPos - 1] == '0') {
            --this.curPos;
        }
        if (this.characters[this.curPos - 1] == '.') {
            ++this.curPos;
        }
        if (exponent != 0) {
            this.characters[this.curPos++] = 69;
            this.append(exponent);
        }
        return this;
    }
}

