/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;

public class DataOutputStream
extends OutputStream {
    protected int written;
    protected OutputStream out;

    public DataOutputStream(OutputStream out) {
        this.out = out;
    }

    private void incCount(int value) {
        int temp;
        this.written = temp = this.written + value;
    }

    public synchronized void write(int b) throws IOException {
        this.out.write(b);
        this.incCount(1);
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.incCount(len);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public final void writeBoolean(boolean v) throws IOException {
        this.out.write(v ? 1 : 0);
        this.incCount(1);
    }

    public final void writeByte(int v) throws IOException {
        this.out.write(v);
        this.incCount(1);
    }

    public final void writeShort(int v) throws IOException {
        OutputStream out = this.out;
        out.write(v >>> 8 & 0xFF);
        out.write(v >>> 0 & 0xFF);
        this.incCount(2);
    }

    public final void writeChar(int v) throws IOException {
        OutputStream out = this.out;
        out.write(v >>> 8 & 0xFF);
        out.write(v >>> 0 & 0xFF);
        this.incCount(2);
    }

    public final void writeInt(int v) throws IOException {
        OutputStream out = this.out;
        out.write(v >>> 24 & 0xFF);
        out.write(v >>> 16 & 0xFF);
        out.write(v >>> 8 & 0xFF);
        out.write(v >>> 0 & 0xFF);
        this.incCount(4);
    }

    public final void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public final int size() {
        return this.written;
    }
}

