/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm;

import java.io.IOException;
import js.tinyvm.Binary;
import js.tinyvm.TinyVMException;
import js.tinyvm.WritableData;
import js.tinyvm.io.IByteWriter;
import js.tinyvm.io.IOUtilities;

public class MasterRecord
implements WritableData {
    Binary _binary;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MasterRecord(Binary binary) {
        if (!$assertionsDisabled && binary == null) {
            throw new AssertionError((Object)"Precondition: binary != null");
        }
        this._binary = binary;
    }

    public void dump(IByteWriter writer) throws TinyVMException {
        if (!$assertionsDisabled && writer == null) {
            throw new AssertionError((Object)"Precondition: writer != null");
        }
        int pMagicNumber = 51958;
        int pConstantTableOffset = this._binary.iConstantTable.getOffset();
        int pStaticFieldsOffset = this._binary.iStaticFields.getOffset();
        int pStaticStateOffset = this._binary.iStaticState.getOffset();
        int pStaticStateLength = (this._binary.iStaticState.getLength() + 1) / 2;
        int pNumStaticFields = this._binary.iStaticFields.size();
        int pEntryClassesOffset = this._binary.iEntryClassIndices.getOffset();
        int pNumEntryClasses = this._binary.iEntryClassIndices.size();
        if (!$assertionsDisabled && pNumEntryClasses >= 256) {
            throw new AssertionError((Object)"Check: not too much classes");
        }
        int pLastClass = this._binary.iClassTable.size() - 1;
        if (!($assertionsDisabled || pLastClass >= 0 && pLastClass < 256)) {
            throw new AssertionError((Object)"Check: class index in range");
        }
        try {
            writer.writeU2(pMagicNumber);
            writer.writeU2(pConstantTableOffset);
            writer.writeU2(pStaticFieldsOffset);
            writer.writeU2(pStaticStateOffset);
            writer.writeU2(pStaticStateLength);
            writer.writeU2(pNumStaticFields);
            writer.writeU2(pEntryClassesOffset);
            writer.writeU1(pNumEntryClasses);
            writer.writeU1(pLastClass);
            IOUtilities.writePadding(writer, 2);
        }
        catch (IOException e) {
            throw new TinyVMException(e.getMessage(), e);
        }
    }

    public int getLength() {
        return IOUtilities.adjustedSize(16, 2);
    }

    static {
        $assertionsDisabled = !MasterRecord.class.desiredAssertionStatus();
    }
}

