/**
 *  BlueCove - Java library for Bluetooth
 *  Copyright (C) 2006-2007 Vlad Skarzhevskyy
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  @version $Id: UtilsTest.java 918 2007-08-14 20:20:37Z skarzhevskyy $
 */
package com.intel.bluetooth;

import junit.framework.TestCase;

/**
 * @author vlads
 *
 */
public class UtilsTest extends TestCase {

	private void validateLong(long l) {
		assertEquals("hex of " + l, Long.toHexString(l), Utils.toHexString(l));
	}
			
	public void testLongtoHexString() {
		validateLong(0x0100);
		validateLong(0xBCfffffAffl);
	}
}
