/**
 *  BlueCove - Java library for Bluetooth
 *  Copyright (C) 2006-2007 Vlad Skarzhevskyy
 * 
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  @version $Id: BluetoothConnectionAccessAdapter.java 1058 2007-10-05 02:17:39Z skarzhevskyy $
 */ 
package com.intel.bluetooth;

import java.io.IOException;

import javax.bluetooth.RemoteDevice;

public abstract class BluetoothConnectionAccessAdapter implements  BluetoothConnectionAccess {

	protected abstract BluetoothConnectionAccess getImpl();
	
	/* (non-Javadoc)
	 * @see com.intel.bluetooth.BluetoothConnectionAccess#getRemoteAddress()
	 */
	public long getRemoteAddress() throws IOException {
		return getImpl().getRemoteAddress();
	}

	/* (non-Javadoc)
	 * @see com.intel.bluetooth.BluetoothConnectionAccess#getRemoteDevice()
	 */
	public RemoteDevice getRemoteDevice() {
		return getImpl().getRemoteDevice();
	}

	/* (non-Javadoc)
	 * @see com.intel.bluetooth.BluetoothConnectionAccess#getSecurityOpt()
	 */
	public int getSecurityOpt() {
		return getImpl().getSecurityOpt();
	}

	/* (non-Javadoc)
	 * @see com.intel.bluetooth.BluetoothConnectionAccess#setRemoteDevice(javax.bluetooth.RemoteDevice)
	 */
	public void setRemoteDevice(RemoteDevice remoteDevice) {
		getImpl().setRemoteDevice(remoteDevice);
	}

	public BluetoothStack getBluetoothStack() {
		return getImpl().getBluetoothStack();
	}
}
