/*
 * Decompiled with CFR 0.152.
 */
package javax.bluetooth;

import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.NotImplementedIOException;
import com.intel.bluetooth.RemoteDeviceHelper;
import java.io.IOException;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.LocalDevice;
import javax.microedition.io.Connection;

public class RemoteDevice {
    private String addressStr;
    private long addressLong;

    protected RemoteDevice(String address) {
        if (address == null) {
            throw new NullPointerException("address is null");
        }
        String errorMsg = "Malformed address: " + address;
        if (address.length() != 12) {
            throw new IllegalArgumentException(errorMsg);
        }
        if (address.startsWith("-")) {
            throw new IllegalArgumentException(errorMsg);
        }
        DebugLog.debug("new RemoteDevice", address);
        this.addressStr = RemoteDeviceHelper.getBluetoothAddress(address);
        try {
            if (this.addressStr.equals(LocalDevice.getLocalDevice().getBluetoothAddress())) {
                throw new IllegalArgumentException("can't use the LocalDevice address.");
            }
        }
        catch (BluetoothStateException e) {
            throw new RuntimeException("Can't initialize bluetooth support");
        }
        this.addressLong = RemoteDeviceHelper.getAddress(address);
    }

    public boolean isTrustedDevice() {
        return RemoteDeviceHelper.isTrustedDevice(this);
    }

    public String getFriendlyName(boolean alwaysAsk) throws IOException {
        return RemoteDeviceHelper.getFriendlyName(this, this.addressLong, alwaysAsk);
    }

    public final String getBluetoothAddress() {
        return this.addressStr;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof RemoteDevice && ((RemoteDevice)obj).addressLong == this.addressLong;
    }

    public int hashCode() {
        return new Long(this.addressLong).hashCode();
    }

    public static RemoteDevice getRemoteDevice(Connection conn) throws IOException {
        return RemoteDeviceHelper.getRemoteDevice(conn);
    }

    public boolean authenticate() throws IOException {
        throw new NotImplementedIOException();
    }

    public boolean authorize(Connection conn) throws IOException {
        throw new NotImplementedIOException();
    }

    public boolean encrypt(Connection conn, boolean on) throws IOException {
        throw new NotImplementedIOException();
    }

    public boolean isAuthenticated() {
        return RemoteDeviceHelper.isAuthenticated(this);
    }

    public boolean isAuthorized(Connection conn) throws IOException {
        throw new NotImplementedIOException();
    }

    public boolean isEncrypted() {
        return RemoteDeviceHelper.isEncrypted(this);
    }
}

