/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth.obex;

import com.intel.bluetooth.BluetoothConnectionAccess;
import com.intel.bluetooth.BluetoothStack;
import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.obex.OBEXAuthentication;
import com.intel.bluetooth.obex.OBEXConnectionParams;
import com.intel.bluetooth.obex.OBEXHeaderSetImpl;
import com.intel.bluetooth.obex.OBEXUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.bluetooth.RemoteDevice;
import javax.microedition.io.Connection;
import javax.microedition.io.StreamConnection;
import javax.obex.Authenticator;
import javax.obex.HeaderSet;
import javax.obex.ServerRequestHandler;

abstract class OBEXSessionBase
implements Connection,
BluetoothConnectionAccess {
    protected StreamConnection conn;
    protected InputStream is;
    protected OutputStream os;
    protected long connectionID;
    protected int mtu = 1024;
    protected Authenticator authenticator;
    protected OBEXConnectionParams obexConnectionParams;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OBEXSessionBase(StreamConnection conn, OBEXConnectionParams obexConnectionParams) throws IOException {
        if (obexConnectionParams == null) {
            throw new NullPointerException("obexConnectionParams is null");
        }
        this.conn = conn;
        this.obexConnectionParams = obexConnectionParams;
        this.mtu = obexConnectionParams.mtu;
        this.connectionID = -1L;
        boolean initOK = false;
        try {
            this.os = conn.openOutputStream();
            this.is = conn.openInputStream();
            initOK = true;
        }
        finally {
            if (!initOK) {
                try {
                    this.close();
                }
                catch (IOException e) {
                    DebugLog.error("close error", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        StreamConnection c = this.conn;
        this.conn = null;
        try {
            if (this.is != null) {
                this.is.close();
                this.is = null;
            }
            if (this.os != null) {
                this.os.close();
                this.os = null;
            }
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
    }

    protected boolean isClosed() {
        return this.conn == null;
    }

    public static HeaderSet createOBEXHeaderSet() {
        return new OBEXHeaderSetImpl();
    }

    static void validateCreatedHeaderSet(HeaderSet headers) {
        OBEXHeaderSetImpl.validateCreatedHeaderSet(headers);
    }

    protected void writeOperation(int commId, byte[] data) throws IOException {
        this.writeOperation(commId, data, null);
    }

    protected void writeOperation(int commId, byte[] data1, byte[] data2) throws IOException {
        int len = 3;
        if (this.connectionID != -1L) {
            len += 5;
        }
        if (data1 != null) {
            len += data1.length;
        }
        if (data2 != null) {
            len += data2.length;
        }
        if (len > this.mtu) {
            throw new IOException("Can't sent more data than in MTU, len=" + len + ", mtu=" + this.mtu);
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        OBEXHeaderSetImpl.writeObexLen(buf, commId, len);
        if (this.connectionID != -1L) {
            OBEXHeaderSetImpl.writeObexInt(buf, 203, this.connectionID);
        }
        if (data1 != null) {
            buf.write(data1);
        }
        if (data2 != null) {
            buf.write(data2, 0, data2.length);
        }
        this.os.write(buf.toByteArray());
        this.os.flush();
        DebugLog.debug0x("obex sent", commId);
        DebugLog.debug("obex sent len", len);
    }

    protected byte[] readOperation() throws IOException {
        byte[] header = new byte[3];
        OBEXUtils.readFully(this.is, this.obexConnectionParams, header);
        DebugLog.debug0x("obex received", header[0] & 0xFF);
        DebugLog.debug("obex response", OBEXUtils.toStringObexResponseCodes(header[0]));
        int lenght = OBEXUtils.bytesToShort(header[1], header[2]);
        if (lenght == 3) {
            return header;
        }
        if (lenght < 3 || lenght > 65535) {
            throw new IOException("Invalid packet lenght");
        }
        byte[] data = new byte[lenght];
        System.arraycopy(header, 0, data, 0, header.length);
        OBEXUtils.readFully(this.is, this.obexConnectionParams, data, header.length, lenght - header.length);
        if (this.is.available() > 0) {
            DebugLog.debug("has more data after read", this.is.available());
        }
        return data;
    }

    private void validateBluetoothConnection() {
        if (!(this.conn instanceof BluetoothConnectionAccess)) {
            throw new IllegalArgumentException("Not a Bluetooth connection " + this.conn.getClass().getName());
        }
    }

    void validateAuthenticationResponse(OBEXHeaderSetImpl requestHeaders, OBEXHeaderSetImpl incomingHeaders) throws IOException {
        if (requestHeaders != null && requestHeaders.hasAuthenticationChallenge() && !incomingHeaders.hasAuthenticationResponse()) {
            throw new IOException("Authentication response is missing");
        }
        this.handleAuthenticationResponse(incomingHeaders, null);
    }

    void handleAuthenticationResponse(OBEXHeaderSetImpl incomingHeaders, ServerRequestHandler serverHandler) throws IOException {
        if (incomingHeaders.hasAuthenticationResponse()) {
            if (this.authenticator == null) {
                throw new IOException("Authenticator required for authentication");
            }
            OBEXAuthentication.handleAuthenticationResponse(incomingHeaders, this.authenticator, serverHandler);
        }
    }

    void handleAuthenticationChallenge(OBEXHeaderSetImpl incomingHeaders, OBEXHeaderSetImpl replyHeaders) throws IOException {
        if (incomingHeaders.hasAuthenticationChallenge()) {
            if (this.authenticator == null) {
                throw new IOException("Authenticator required for authentication");
            }
            OBEXAuthentication.handleAuthenticationChallenge(incomingHeaders, replyHeaders, this.authenticator);
        }
    }

    public long getRemoteAddress() throws IOException {
        this.validateBluetoothConnection();
        return ((BluetoothConnectionAccess)((Object)this.conn)).getRemoteAddress();
    }

    public RemoteDevice getRemoteDevice() {
        this.validateBluetoothConnection();
        return ((BluetoothConnectionAccess)((Object)this.conn)).getRemoteDevice();
    }

    public int getSecurityOpt() {
        this.validateBluetoothConnection();
        return ((BluetoothConnectionAccess)((Object)this.conn)).getSecurityOpt();
    }

    public void setRemoteDevice(RemoteDevice remoteDevice) {
        this.validateBluetoothConnection();
        ((BluetoothConnectionAccess)((Object)this.conn)).setRemoteDevice(remoteDevice);
    }

    public BluetoothStack getBluetoothStack() {
        this.validateBluetoothConnection();
        return ((BluetoothConnectionAccess)((Object)this.conn)).getBluetoothStack();
    }
}

