/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth.obex;

import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.obex.OBEXAuthentication;
import com.intel.bluetooth.obex.OBEXUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.Vector;
import javax.obex.HeaderSet;

class OBEXHeaderSetImpl
implements HeaderSet {
    static final int OBEX_HDR_COUNT = 192;
    static final int OBEX_HDR_NAME = 1;
    static final int OBEX_HDR_TYPE = 66;
    static final int OBEX_HDR_LENGTH = 195;
    static final int OBEX_HDR_TIME = 68;
    static final int OBEX_HDR_TIME2 = 196;
    static final int OBEX_HDR_DESCRIPTION = 5;
    static final int OBEX_HDR_TARGET = 70;
    static final int OBEX_HDR_HTTP = 71;
    static final int OBEX_HDR_BODY = 72;
    static final int OBEX_HDR_BODY_END = 73;
    static final int OBEX_HDR_WHO = 74;
    static final int OBEX_HDR_CONNECTION = 203;
    static final int OBEX_HDR_APP_PARAM = 76;
    static final int OBEX_HDR_AUTH_CHALLENGE = 77;
    static final int OBEX_HDR_AUTH_RESPONSE = 78;
    static final int OBEX_HDR_OBJECTCLASS = 79;
    static final int OBEX_HDR_CREATOR = 207;
    static final int OBEX_HDR_WANUUID = 80;
    static final int OBEX_HDR_SESSIONPARAM = 82;
    static final int OBEX_HDR_SESSIONSEQ = 147;
    static final int OBEX_HDR_USER = 48;
    static final int OBEX_HDR_HI_MASK = 192;
    static final int OBEX_HDR_ID_MASK = 63;
    static final int OBEX_STRING = 0;
    static final int OBEX_BYTE_STREAM = 64;
    static final int OBEX_BYTE = 128;
    static final int OBEX_INT = 192;
    private static final int OBEX_MAX_FIELD_LEN = 255;
    private int responseCode;
    private Hashtable headerValues = new Hashtable();
    private Vector authResponses;
    private Vector authChallenges;
    private static final int NO_RESPONSE_CODE = Integer.MIN_VALUE;

    OBEXHeaderSetImpl() {
        this(Integer.MIN_VALUE);
    }

    private OBEXHeaderSetImpl(int responseCode) {
        this.responseCode = responseCode;
        this.authResponses = new Vector();
        this.authChallenges = new Vector();
    }

    static void validateCreatedHeaderSet(HeaderSet headers) {
        if (headers == null) {
            return;
        }
        if (!(headers instanceof OBEXHeaderSetImpl)) {
            throw new IllegalArgumentException("Illegal HeaderSet type");
        }
        if (((OBEXHeaderSetImpl)headers).responseCode != Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Illegal HeaderSet");
        }
    }

    private void validateHeaderID(int headerID) throws IllegalArgumentException {
        if (headerID < 0 || headerID > 255) {
            throw new IllegalArgumentException("Expected header ID in range 0 to 255");
        }
        int identifier = headerID & 0x3F;
        if (identifier >= 16 && identifier < 47) {
            throw new IllegalArgumentException("Reserved header ID");
        }
    }

    public void setHeader(int headerID, Object headerValue) {
        this.validateHeaderID(headerID);
        if (headerValue == null) {
            this.headerValues.remove(new Integer(headerID));
        } else {
            if (headerID == 68 || headerID == 196) {
                if (!(headerValue instanceof Calendar)) {
                    throw new IllegalArgumentException("Expected java.util.Calendar");
                }
            } else if (headerID == 66) {
                if (!(headerValue instanceof String)) {
                    throw new IllegalArgumentException("Expected java.lang.String");
                }
            } else {
                switch (headerID & 0xC0) {
                    case 0: {
                        if (headerValue instanceof String) break;
                        throw new IllegalArgumentException("Expected java.lang.String");
                    }
                    case 64: {
                        if (headerValue instanceof byte[]) break;
                        throw new IllegalArgumentException("Expected byte[]");
                    }
                    case 128: {
                        if (headerValue instanceof Byte) break;
                        throw new IllegalArgumentException("Expected java.lang.Byte");
                    }
                    case 192: {
                        if (!(headerValue instanceof Long)) {
                            throw new IllegalArgumentException("Expected java.lang.Long");
                        }
                        long v = (Long)headerValue;
                        if (v >= 0L && v <= 0xFFFFFFFFL) break;
                        throw new IllegalArgumentException("Expected long in range 0 to 2^32-1");
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported encoding " + (headerID & 0xC0));
                    }
                }
            }
            this.headerValues.put(new Integer(headerID), headerValue);
        }
    }

    public Object getHeader(int headerID) throws IOException {
        this.validateHeaderID(headerID);
        return this.headerValues.get(new Integer(headerID));
    }

    public int[] getHeaderList() throws IOException {
        if (this.headerValues.size() == 0) {
            return null;
        }
        int[] headerIDArray = new int[this.headerValues.size()];
        int i = 0;
        Enumeration e = this.headerValues.keys();
        while (e.hasMoreElements()) {
            headerIDArray[i++] = (Integer)e.nextElement();
        }
        return headerIDArray;
    }

    public int getResponseCode() throws IOException {
        if (this.responseCode == Integer.MIN_VALUE) {
            throw new IOException();
        }
        return this.responseCode;
    }

    static HeaderSet cloneHeaders(HeaderSet headers) throws IOException {
        if (headers == null) {
            return null;
        }
        if (!(headers instanceof OBEXHeaderSetImpl)) {
            throw new IllegalArgumentException("Illegal HeaderSet type");
        }
        OBEXHeaderSetImpl hs = new OBEXHeaderSetImpl(((OBEXHeaderSetImpl)headers).responseCode);
        int[] headerIDArray = headers.getHeaderList();
        for (int i = 0; headerIDArray != null && i < headerIDArray.length; ++i) {
            int headerID = headerIDArray[i];
            hs.setHeader(headerID, headers.getHeader(headerID));
        }
        return hs;
    }

    public void createAuthenticationChallenge(String realm, boolean userID, boolean access) {
        this.authChallenges.addElement(OBEXAuthentication.createChallenge(realm, userID, access));
    }

    void addAuthenticationResponse(byte[] authResponse) {
        this.authResponses.addElement(authResponse);
    }

    boolean hasAuthenticationChallenge() {
        return !this.authChallenges.isEmpty();
    }

    Enumeration getAuthenticationChallenges() {
        return this.authChallenges.elements();
    }

    boolean hasAuthenticationResponse() {
        return !this.authResponses.isEmpty();
    }

    Enumeration getAuthenticationResponses() {
        return this.authResponses.elements();
    }

    static long readObexInt(byte[] data, int off) throws IOException {
        long l = 0L;
        for (int i = 0; i < 4; ++i) {
            l <<= 8;
            l += (long)(data[off + i] & 0xFF);
        }
        return l;
    }

    static void writeObexInt(OutputStream out, int headerID, long data) throws IOException {
        byte[] b = new byte[]{(byte)headerID, (byte)(data >>> 24 & 0xFFL), (byte)(data >>> 16 & 0xFFL), (byte)(data >>> 8 & 0xFFL), (byte)(data >>> 0 & 0xFFL)};
        out.write(b);
    }

    static void writeObexLen(OutputStream out, int headerID, int len) throws IOException {
        byte[] b = new byte[3];
        b[0] = (byte)headerID;
        if (len < 0 || len > 65535) {
            throw new IOException("very large data" + len);
        }
        b[1] = OBEXUtils.hiByte(len);
        b[2] = OBEXUtils.loByte(len);
        out.write(b);
    }

    static void writeObexASCII(OutputStream out, int headerID, String value) throws IOException {
        OBEXHeaderSetImpl.writeObexLen(out, headerID, 3 + value.length() + 1);
        out.write(value.getBytes("iso-8859-1"));
        out.write(0);
    }

    static void writeObexUnicode(OutputStream out, int headerID, String value) throws IOException {
        if (value.length() == 0) {
            OBEXHeaderSetImpl.writeObexLen(out, headerID, 3);
            return;
        }
        byte[] b = OBEXUtils.getUTF16Bytes(value);
        OBEXHeaderSetImpl.writeObexLen(out, headerID, 3 + b.length + 2);
        out.write(b);
        out.write(new byte[]{0, 0});
    }

    static byte[] toByteArray(HeaderSet headers) throws IOException {
        if (headers == null) {
            return new byte[0];
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        int[] headerIDArray = headers.getHeaderList();
        block6: for (int i = 0; headerIDArray != null && i < headerIDArray.length; ++i) {
            Calendar c;
            int hi = headerIDArray[i];
            if (hi == 68) {
                c = (Calendar)headers.getHeader(hi);
                OBEXHeaderSetImpl.writeObexLen(buf, hi, 19);
                OBEXHeaderSetImpl.writeTimeISO8601(buf, c);
                continue;
            }
            if (hi == 196) {
                c = (Calendar)headers.getHeader(hi);
                OBEXHeaderSetImpl.writeObexInt(buf, hi, c.getTime().getTime() / 1000L);
                continue;
            }
            if (hi == 66) {
                OBEXHeaderSetImpl.writeObexASCII(buf, hi, (String)headers.getHeader(hi));
                continue;
            }
            switch (hi & 0xC0) {
                case 0: {
                    OBEXHeaderSetImpl.writeObexUnicode(buf, hi, (String)headers.getHeader(hi));
                    continue block6;
                }
                case 64: {
                    byte[] data = (byte[])headers.getHeader(hi);
                    OBEXHeaderSetImpl.writeObexLen(buf, hi, 3 + data.length);
                    buf.write(data);
                    continue block6;
                }
                case 128: {
                    buf.write(hi);
                    buf.write(((Byte)headers.getHeader(hi)).byteValue());
                    continue block6;
                }
                case 192: {
                    OBEXHeaderSetImpl.writeObexInt(buf, hi, (Long)headers.getHeader(hi));
                    continue block6;
                }
                default: {
                    throw new IOException("Unsupported encoding " + (hi & 0xC0));
                }
            }
        }
        if (headerIDArray != null && headerIDArray.length != 0) {
            DebugLog.debug("written headers", headerIDArray.length);
        }
        Enumeration iter = ((OBEXHeaderSetImpl)headers).authChallenges.elements();
        while (iter.hasMoreElements()) {
            byte[] authChallenge = (byte[])iter.nextElement();
            OBEXHeaderSetImpl.writeObexLen(buf, 77, 3 + authChallenge.length);
            buf.write(authChallenge);
            DebugLog.debug("written AUTH_CHALLENGE");
        }
        iter = ((OBEXHeaderSetImpl)headers).authResponses.elements();
        while (iter.hasMoreElements()) {
            byte[] authResponse = (byte[])iter.nextElement();
            OBEXHeaderSetImpl.writeObexLen(buf, 78, 3 + authResponse.length);
            buf.write(authResponse);
            DebugLog.debug("written AUTH_RESPONSE");
        }
        return buf.toByteArray();
    }

    static OBEXHeaderSetImpl readHeaders(byte[] buf, int off) throws IOException {
        return OBEXHeaderSetImpl.readHeaders(new OBEXHeaderSetImpl(Integer.MIN_VALUE), buf, off);
    }

    static OBEXHeaderSetImpl readHeaders(byte responseCode, byte[] buf, int off) throws IOException {
        return OBEXHeaderSetImpl.readHeaders(new OBEXHeaderSetImpl(0xFF & responseCode), buf, off);
    }

    private static OBEXHeaderSetImpl readHeaders(OBEXHeaderSetImpl hs, byte[] buf, int off) throws IOException {
        int count = 0;
        while (off < buf.length) {
            int hi = 0xFF & buf[off];
            int len = 0;
            switch (hi & 0xC0) {
                case 0: {
                    len = OBEXUtils.bytesToShort(buf[off + 1], buf[off + 2]);
                    if (len == 3) {
                        hs.setHeader(hi, "");
                        break;
                    }
                    byte[] data = new byte[len - 5];
                    System.arraycopy(buf, off + 3, data, 0, data.length);
                    hs.setHeader(hi, OBEXUtils.newStringUTF16(data));
                    break;
                }
                case 64: {
                    len = OBEXUtils.bytesToShort(buf[off + 1], buf[off + 2]);
                    byte[] data = new byte[len - 3];
                    System.arraycopy(buf, off + 3, data, 0, data.length);
                    if (hi == 66) {
                        if (data[data.length - 1] != 0) {
                            hs.setHeader(hi, new String(data, "iso-8859-1"));
                            break;
                        }
                        hs.setHeader(hi, new String(data, 0, data.length - 1, "iso-8859-1"));
                        break;
                    }
                    if (hi == 68) {
                        hs.setHeader(hi, OBEXHeaderSetImpl.readTimeISO8601(data));
                        break;
                    }
                    if (hi == 77) {
                        hs.authChallenges.addElement(data);
                        DebugLog.debug("received AUTH_CHALLENGE");
                        break;
                    }
                    if (hi == 78) {
                        hs.authResponses.addElement(data);
                        DebugLog.debug("received AUTH_RESPONSE");
                        break;
                    }
                    hs.setHeader(hi, data);
                    break;
                }
                case 128: {
                    len = 2;
                    hs.setHeader(hi, new Byte(buf[off + 1]));
                    break;
                }
                case 192: {
                    len = 5;
                    long intValue = OBEXHeaderSetImpl.readObexInt(buf, off + 1);
                    if (hi == 196) {
                        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                        cal.setTime(new Date(intValue * 1000L));
                        hs.setHeader(hi, cal);
                        break;
                    }
                    hs.setHeader(hi, new Long(intValue));
                    break;
                }
                default: {
                    throw new IOException("Unsupported encoding " + (hi & 0xC0));
                }
            }
            off += len;
            ++count;
        }
        if (count != 0) {
            DebugLog.debug("read headers", count);
        }
        return hs;
    }

    private static byte[] d4(int i) {
        byte[] b = new byte[4];
        int d = 1000;
        for (int k = 0; k < 4; ++k) {
            b[k] = (byte)(i / d + 48);
            i %= d;
            d /= 10;
        }
        return b;
    }

    private static byte[] d2(int i) {
        byte[] b = new byte[]{(byte)(i / 10 + 48), (byte)(i % 10 + 48)};
        return b;
    }

    static void writeTimeISO8601(OutputStream out, Calendar c) throws IOException {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.setTime(c.getTime());
        out.write(OBEXHeaderSetImpl.d4(cal.get(1)));
        out.write(OBEXHeaderSetImpl.d2(cal.get(2) + 1));
        out.write(OBEXHeaderSetImpl.d2(cal.get(5)));
        out.write(84);
        out.write(OBEXHeaderSetImpl.d2(cal.get(11)));
        out.write(OBEXHeaderSetImpl.d2(cal.get(12)));
        out.write(OBEXHeaderSetImpl.d2(cal.get(13)));
        out.write(90);
    }

    static Calendar readTimeISO8601(byte[] data) throws IOException {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        if (data.length != 16 || data[8] != 84 || data[15] != 90) {
            throw new IOException("Invalid ISO-8601 date " + new String(data));
        }
        cal.set(1, Integer.valueOf(new String(data, 0, 4)));
        cal.set(2, Integer.valueOf(new String(data, 4, 2)) - 1);
        cal.set(5, Integer.valueOf(new String(data, 6, 2)));
        cal.set(11, Integer.valueOf(new String(data, 9, 2)));
        cal.set(12, Integer.valueOf(new String(data, 11, 2)));
        cal.set(13, Integer.valueOf(new String(data, 13, 2)));
        return cal;
    }
}

