/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.BlueCoveImpl;
import com.intel.bluetooth.BluetoothConnectionAccess;
import com.intel.bluetooth.BluetoothStack;
import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.Utils;
import com.intel.bluetooth.WeakVectorFactory;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.RemoteDevice;
import javax.microedition.io.Connection;

public abstract class RemoteDeviceHelper {
    private static Hashtable devicesCashed = new Hashtable();

    private RemoteDeviceHelper() {
    }

    private static RemoteDeviceWithExtendedInfo getCashedDeviceWithExtendedInfo(long address) {
        Long key = new Long(address);
        return (RemoteDeviceWithExtendedInfo)devicesCashed.get(key);
    }

    static RemoteDevice getCashedDevice(long address) {
        return RemoteDeviceHelper.getCashedDeviceWithExtendedInfo(address);
    }

    static RemoteDevice createRemoteDevice(BluetoothStack bluetoothStack, long address, String name, boolean paired) {
        RemoteDeviceWithExtendedInfo dev = RemoteDeviceHelper.getCashedDeviceWithExtendedInfo(address);
        if (dev == null) {
            dev = new RemoteDeviceWithExtendedInfo(bluetoothStack, address, name);
            devicesCashed.put(new Long(address), dev);
            DebugLog.debug0x("new devicesCashed", address);
        } else if (!Utils.isStringSet(dev.name)) {
            dev.name = name;
        } else if (Utils.isStringSet(name)) {
            dev.name = name;
        }
        if (paired) {
            dev.paired = paired;
        }
        return dev;
    }

    private static RemoteDeviceWithExtendedInfo remoteDeviceImpl(RemoteDevice device) {
        return (RemoteDeviceWithExtendedInfo)RemoteDeviceHelper.createRemoteDevice(null, device);
    }

    static RemoteDevice createRemoteDevice(BluetoothStack bluetoothStack, RemoteDevice device) throws RuntimeException {
        if (device instanceof RemoteDeviceWithExtendedInfo) {
            return device;
        }
        if (bluetoothStack == null) {
            try {
                bluetoothStack = BlueCoveImpl.instance().getBluetoothStack();
            }
            catch (BluetoothStateException e) {
                throw new RuntimeException("Can't initialize bluetooth support");
            }
        }
        return RemoteDeviceHelper.createRemoteDevice(bluetoothStack, RemoteDeviceHelper.getAddress(device), null, false);
    }

    public static String getFriendlyName(RemoteDevice device, long address, boolean alwaysAsk) throws IOException {
        String name = null;
        if (!(device instanceof RemoteDeviceWithExtendedInfo)) {
            device = RemoteDeviceHelper.createRemoteDevice(null, device);
        }
        name = ((RemoteDeviceWithExtendedInfo)device).name;
        if (alwaysAsk || !Utils.isStringSet(name)) {
            name = ((RemoteDeviceWithExtendedInfo)device).bluetoothStack.getRemoteDeviceFriendlyName(address);
            if (Utils.isStringSet(name)) {
                ((RemoteDeviceWithExtendedInfo)device).name = name;
            } else {
                throw new IOException("Can't query remote device");
            }
        }
        return name;
    }

    public static RemoteDevice getRemoteDevice(Connection conn) throws IOException {
        if (!(conn instanceof BluetoothConnectionAccess)) {
            throw new IllegalArgumentException("Not a Bluetooth connection " + conn.getClass().getName());
        }
        return RemoteDeviceHelper.createRemoteDevice(((BluetoothConnectionAccess)((Object)conn)).getBluetoothStack(), ((BluetoothConnectionAccess)((Object)conn)).getRemoteAddress(), null, false);
    }

    public static RemoteDevice[] retrieveDevices(int option) {
        switch (option) {
            case 1: {
                if (devicesCashed.size() == 0) {
                    return null;
                }
                Vector<RemoteDeviceWithExtendedInfo> devicesPaired = new Vector<RemoteDeviceWithExtendedInfo>();
                Enumeration en = devicesCashed.elements();
                while (en.hasMoreElements()) {
                    RemoteDeviceWithExtendedInfo d = (RemoteDeviceWithExtendedInfo)en.nextElement();
                    if (!d.isTrustedDevice()) continue;
                    devicesPaired.addElement(d);
                }
                if (devicesPaired.size() == 0) {
                    return null;
                }
                RemoteDevice[] pdevices = new RemoteDevice[devicesPaired.size()];
                int i = 0;
                Enumeration en2 = devicesPaired.elements();
                while (en2.hasMoreElements()) {
                    pdevices[i++] = (RemoteDevice)en2.nextElement();
                }
                return pdevices;
            }
            case 0: {
                if (devicesCashed.size() == 0) {
                    return null;
                }
                RemoteDevice[] devices = new RemoteDevice[devicesCashed.size()];
                int k = 0;
                Enumeration en = devicesCashed.elements();
                while (en.hasMoreElements()) {
                    devices[k++] = (RemoteDevice)en.nextElement();
                }
                return devices;
            }
        }
        throw new IllegalArgumentException("invalid option");
    }

    public static int openConnections() {
        int c = 0;
        Enumeration en = devicesCashed.elements();
        while (en.hasMoreElements()) {
            c += ((RemoteDeviceWithExtendedInfo)en.nextElement()).connectionsCount();
        }
        return c;
    }

    public static String getBluetoothAddress(String address) {
        String s = address.toUpperCase();
        return "000000000000".substring(s.length()) + s;
    }

    static String getBluetoothAddress(long address) {
        return RemoteDeviceHelper.getBluetoothAddress(Utils.toHexString(address));
    }

    public static long getAddress(String bluetoothAddress) {
        if (bluetoothAddress.indexOf(45) != -1) {
            throw new IllegalArgumentException("Illegal bluetoothAddress {" + bluetoothAddress + "}");
        }
        try {
            return Long.parseLong(bluetoothAddress, 16);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Illegal bluetoothAddress {" + bluetoothAddress + "}");
        }
    }

    static long getAddress(RemoteDevice device) {
        if (device instanceof RemoteDeviceWithExtendedInfo) {
            return ((RemoteDeviceWithExtendedInfo)device).addressLong;
        }
        return RemoteDeviceHelper.getAddress(device.getBluetoothAddress());
    }

    static void setStackAttributes(BluetoothStack bluetoothStack, RemoteDevice device, Object key, Object value) {
        RemoteDeviceWithExtendedInfo devInfo = (RemoteDeviceWithExtendedInfo)RemoteDeviceHelper.createRemoteDevice(bluetoothStack, device);
        devInfo.setStackAttributes(key, value);
    }

    static Object getStackAttributes(RemoteDevice device, Object key) {
        RemoteDeviceWithExtendedInfo devInfo = null;
        devInfo = device instanceof RemoteDeviceWithExtendedInfo ? (RemoteDeviceWithExtendedInfo)device : RemoteDeviceHelper.getCashedDeviceWithExtendedInfo(RemoteDeviceHelper.getAddress(device));
        if (devInfo != null) {
            return devInfo.getStackAttributes(key);
        }
        return null;
    }

    public static void connected(BluetoothConnectionAccess connection) throws IOException {
        RemoteDeviceWithExtendedInfo device = (RemoteDeviceWithExtendedInfo)RemoteDeviceHelper.getRemoteDevice((Connection)((Object)connection));
        connection.setRemoteDevice(device);
        device.addConnection(connection);
    }

    public static void disconnected(BluetoothConnectionAccess connection) {
        RemoteDevice d = connection.getRemoteDevice();
        if (d != null) {
            ((RemoteDeviceWithExtendedInfo)d).removeConnection(connection);
            connection.setRemoteDevice(null);
        }
    }

    public static boolean isAuthenticated(RemoteDevice device) {
        return RemoteDeviceHelper.remoteDeviceImpl(device).isAuthenticated();
    }

    public static boolean isEncrypted(RemoteDevice device) {
        return RemoteDeviceHelper.remoteDeviceImpl(device).isEncrypted();
    }

    public static boolean isTrustedDevice(RemoteDevice device) {
        return RemoteDeviceHelper.remoteDeviceImpl(device).isTrustedDevice();
    }

    private static class RemoteDeviceWithExtendedInfo
    extends RemoteDevice {
        String name;
        long addressLong;
        BluetoothStack bluetoothStack;
        private Hashtable stackAttributes;
        private boolean paired;
        private WeakVectorFactory.WeakVector connections;

        private RemoteDeviceWithExtendedInfo(BluetoothStack bluetoothStack, long address, String name) {
            super(RemoteDeviceHelper.getBluetoothAddress(address));
            this.bluetoothStack = bluetoothStack;
            this.name = name;
            this.addressLong = address;
        }

        private void addConnection(Object connection) {
            if (this.connections == null) {
                this.connections = WeakVectorFactory.createWeakVector();
            }
            this.connections.addElement(connection);
            DebugLog.debug("connection open, open now", this.connections.size());
        }

        private void removeConnection(Object connection) {
            if (this.connections == null) {
                return;
            }
            this.connections.removeElement(connection);
            DebugLog.debug("connection closed, open now", this.connections.size());
        }

        private void setStackAttributes(Object key, Object value) {
            if (this.stackAttributes == null) {
                this.stackAttributes = new Hashtable();
            }
            if (value == null) {
                this.stackAttributes.remove(key);
            } else {
                this.stackAttributes.put(key, value);
            }
        }

        private Object getStackAttributes(Object key) {
            if (this.stackAttributes == null) {
                return null;
            }
            return this.stackAttributes.get(key);
        }

        public String toString() {
            return super.getBluetoothAddress();
        }

        int connectionsCount() {
            if (this.connections == null) {
                return 0;
            }
            return this.connections.size();
        }

        boolean hasConnections() {
            return this.connectionsCount() != 0;
        }

        public boolean isAuthenticated() {
            if (!this.hasConnections()) {
                DebugLog.debug("no connections, Authenticated = false");
                return false;
            }
            return ((BluetoothConnectionAccess)this.connections.firstElement()).getSecurityOpt() != 0;
        }

        public boolean isEncrypted() {
            if (!this.hasConnections()) {
                return false;
            }
            return ((BluetoothConnectionAccess)this.connections.firstElement()).getSecurityOpt() == 2;
        }

        public boolean isTrustedDevice() {
            return this.paired;
        }
    }
}

