/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.DeviceInquiryRunnable;
import com.intel.bluetooth.Utils;
import com.intel.bluetooth.UtilsJavaSE;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DiscoveryListener;

class DeviceInquiryThread
extends Thread {
    private DeviceInquiryRunnable stack;
    private int accessCode;
    private DiscoveryListener listener;
    private BluetoothStateException startException;
    private boolean started = false;
    private boolean terminated = false;
    private Object inquiryStartedEvent = new Object();

    private DeviceInquiryThread(DeviceInquiryRunnable stack, int accessCode, DiscoveryListener listener) {
        super("DeviceInquiryThread");
        this.stack = stack;
        this.accessCode = accessCode;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean startInquiry(DeviceInquiryRunnable stack, int accessCode, DiscoveryListener listener) throws BluetoothStateException {
        DeviceInquiryThread t = new DeviceInquiryThread(stack, accessCode, listener);
        UtilsJavaSE.threadSetDaemon(t);
        Object object = t.inquiryStartedEvent;
        synchronized (object) {
            t.start();
            while (!t.started && !t.terminated) {
                try {
                    t.inquiryStartedEvent.wait();
                }
                catch (InterruptedException e) {
                    return false;
                }
                if (t.startException == null) continue;
                throw t.startException;
            }
        }
        DebugLog.debug("startInquiry return", t.started);
        return t.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int discType = 7;
        try {
            discType = this.stack.runDeviceInquiry(this, this.accessCode, this.listener);
        }
        catch (BluetoothStateException e) {
            DebugLog.debug("runDeviceInquiry throw", e);
            this.startException = e;
        }
        catch (Throwable e) {
            DebugLog.error("runDeviceInquiry", e);
        }
        finally {
            this.terminated = true;
            Object e = this.inquiryStartedEvent;
            synchronized (e) {
                this.inquiryStartedEvent.notifyAll();
            }
            DebugLog.debug("runDeviceInquiry ends");
            if (this.started) {
                Utils.j2meUsagePatternDellay();
                this.listener.inquiryCompleted(discType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deviceInquiryStartedCallback() {
        DebugLog.debug("deviceInquiryStartedCallback");
        this.started = true;
        Object object = this.inquiryStartedEvent;
        synchronized (object) {
            this.inquiryStartedEvent.notifyAll();
        }
    }
}

