/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.BluetoothConnectionNotifierParams;
import com.intel.bluetooth.BluetoothConnectionParams;
import com.intel.bluetooth.BluetoothStack;
import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.DeviceInquiryRunnable;
import com.intel.bluetooth.DeviceInquiryThread;
import com.intel.bluetooth.NativeLibLoader;
import com.intel.bluetooth.SearchServicesRunnable;
import com.intel.bluetooth.SearchServicesThread;
import com.intel.bluetooth.ServiceRecordImpl;
import java.io.IOException;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRegistrationException;
import javax.bluetooth.UUID;

class BluetoothStackToshiba
implements BluetoothStack,
DeviceInquiryRunnable,
SearchServicesRunnable {
    private boolean initialized = false;

    BluetoothStackToshiba() {
    }

    public String getStackID() {
        return "toshiba";
    }

    public int getFeatureSet() {
        return 0;
    }

    public native int getLibraryVersion();

    public native int detectBluetoothStack();

    public native void enableNativeDebug(Class var1, boolean var2);

    private native boolean initializeImpl() throws BluetoothStateException;

    private native void destroyImpl();

    public void initialize() throws BluetoothStateException {
        if (!this.initializeImpl()) {
            throw new BluetoothStateException("TOSHIBA BluetoothStack not found");
        }
        this.initialized = true;
    }

    public void destroy() {
        if (this.initialized) {
            this.destroyImpl();
            this.initialized = false;
            DebugLog.debug("TOSHIBA destroyed");
        }
    }

    public boolean isCurrentThreadInterruptedCallback() {
        return Thread.interrupted();
    }

    public native String getLocalDeviceBluetoothAddress() throws BluetoothStateException;

    public DeviceClass getLocalDeviceClass() {
        return null;
    }

    public void setLocalDeviceServiceClasses(int classOfDevice) {
    }

    public String getLocalDeviceName() {
        return null;
    }

    public boolean isLocalDevicePowerOn() {
        return false;
    }

    public String getLocalDeviceProperty(String property) {
        return null;
    }

    public int getLocalDeviceDiscoverable() {
        return 0;
    }

    public boolean setLocalDeviceDiscoverable(int mode) throws BluetoothStateException {
        return false;
    }

    public String getRemoteDeviceFriendlyName(long address) throws IOException {
        return null;
    }

    public boolean startInquiry(int accessCode, DiscoveryListener listener) throws BluetoothStateException {
        return DeviceInquiryThread.startInquiry(this, accessCode, listener);
    }

    public int runDeviceInquiry(DeviceInquiryThread startedNotify, int accessCode, DiscoveryListener listener) throws BluetoothStateException {
        return 0;
    }

    public void deviceDiscoveredCallback(DiscoveryListener listener, long deviceAddr, int deviceClass, String deviceName, boolean paired) {
    }

    public boolean cancelInquiry(DiscoveryListener listener) {
        return false;
    }

    public int runSearchServices(SearchServicesThread startedNotify, int[] attrSet, UUID[] uuidSet, RemoteDevice device, DiscoveryListener listener) throws BluetoothStateException {
        return SearchServicesThread.startSearchServices(this, attrSet, uuidSet, device, listener);
    }

    public int searchServices(int[] attrSet, UUID[] uuidSet, RemoteDevice device, DiscoveryListener listener) throws BluetoothStateException {
        return 0;
    }

    public boolean cancelServiceSearch(int transID) {
        return false;
    }

    public boolean populateServicesRecordAttributeValues(ServiceRecordImpl serviceRecord, int[] attrIDs) throws IOException {
        return false;
    }

    public long connectionRfOpenClientConnection(BluetoothConnectionParams params) throws IOException {
        return 0L;
    }

    public void connectionRfCloseClientConnection(long handle) throws IOException {
    }

    public int getSecurityOpt(long handle, int expected) throws IOException {
        return expected;
    }

    public long rfServerOpen(BluetoothConnectionNotifierParams params, ServiceRecordImpl serviceRecord) throws IOException {
        return 0L;
    }

    public void rfServerClose(long handle, ServiceRecordImpl serviceRecord) throws IOException {
    }

    public void rfServerUpdateServiceRecord(long handle, ServiceRecordImpl serviceRecord, boolean acceptAndOpen) throws ServiceRegistrationException {
    }

    public long rfServerAcceptAndOpenRfServerConnection(long handle) throws IOException {
        return 0L;
    }

    public void connectionRfCloseServerConnection(long handle) throws IOException {
    }

    public void connectionRfFlush(long handle) throws IOException {
    }

    public int connectionRfRead(long handle) throws IOException {
        return 0;
    }

    public int connectionRfRead(long handle, byte[] b, int off, int len) throws IOException {
        return 0;
    }

    public int connectionRfReadAvailable(long handle) throws IOException {
        return 0;
    }

    public void connectionRfWrite(long handle, int b) throws IOException {
    }

    public void connectionRfWrite(long handle, byte[] b, int off, int len) throws IOException {
    }

    public long getConnectionRfRemoteAddress(long handle) throws IOException {
        return 0L;
    }

    public long l2OpenClientConnection(BluetoothConnectionParams params, int receiveMTU, int transmitMTU) throws IOException {
        return 0L;
    }

    public void l2CloseClientConnection(long handle) throws IOException {
    }

    public long l2ServerOpen(BluetoothConnectionNotifierParams params, int receiveMTU, int transmitMTU, ServiceRecordImpl serviceRecord) throws IOException {
        return 0L;
    }

    public void l2ServerUpdateServiceRecord(long handle, ServiceRecordImpl serviceRecord, boolean acceptAndOpen) throws ServiceRegistrationException {
    }

    public long l2ServerAcceptAndOpenServerConnection(long handle) throws IOException {
        return 0L;
    }

    public void l2CloseServerConnection(long handle) throws IOException {
    }

    public void l2ServerClose(long handle, ServiceRecordImpl serviceRecord) throws IOException {
    }

    public boolean l2Ready(long handle) throws IOException {
        return false;
    }

    public int l2Receive(long handle, byte[] inBuf) throws IOException {
        return 0;
    }

    public void l2Send(long handle, byte[] data) throws IOException {
    }

    public int l2GetReceiveMTU(long handle) throws IOException {
        return 0;
    }

    public int l2GetTransmitMTU(long handle) throws IOException {
        return 0;
    }

    public long l2RemoteAddress(long handle) throws IOException {
        return 0L;
    }

    static {
        NativeLibLoader.isAvailable("bluecove");
    }
}

