/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.BluetoothConnectionNotifierParams;
import com.intel.bluetooth.BluetoothConnectionNotifierServiceRecordAccess;
import com.intel.bluetooth.BluetoothConsts;
import com.intel.bluetooth.BluetoothStack;
import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.ServiceRecordImpl;
import com.intel.bluetooth.ServiceRecordsRegistry;
import java.io.IOException;
import java.util.Enumeration;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DataElement;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.ServiceRegistrationException;
import javax.microedition.io.Connection;

abstract class BluetoothConnectionNotifierBase
implements Connection,
BluetoothConnectionNotifierServiceRecordAccess {
    protected BluetoothStack bluetoothStack;
    protected volatile long handle;
    protected ServiceRecordImpl serviceRecord;
    protected boolean closed;
    protected boolean closing;
    protected int securityOpt;

    protected BluetoothConnectionNotifierBase(BluetoothStack bluetoothStack, BluetoothConnectionNotifierParams params) throws BluetoothStateException, Error {
        this.bluetoothStack = bluetoothStack;
        this.closed = false;
        this.closing = false;
        if (params.name == null) {
            throw new NullPointerException("Service name is null");
        }
        this.serviceRecord = new ServiceRecordImpl(this.bluetoothStack, null, 0L);
    }

    protected abstract void stackServerClose(long var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!this.closed) {
            long h = this.handle;
            this.handle = 0L;
            if (h != 0L) {
                ServiceRecordsRegistry.unregister(this.serviceRecord);
                this.closing = true;
                DebugLog.debug("closing ConnectionNotifier");
                try {
                    if (this.serviceRecord.deviceServiceClasses != 0 && (this.bluetoothStack.getFeatureSet() & 4) != 0) {
                        this.bluetoothStack.setLocalDeviceServiceClasses(ServiceRecordsRegistry.getDeviceServiceClasses());
                    }
                    if (h != 0L) {
                        this.stackServerClose(h);
                    }
                    this.closed = true;
                }
                finally {
                    this.closing = false;
                }
            }
        }
    }

    public ServiceRecord getServiceRecord() {
        if (this.closed) {
            throw new IllegalArgumentException("ConnectionNotifier is closed");
        }
        ServiceRecordsRegistry.register(this, this.serviceRecord);
        return this.serviceRecord;
    }

    protected void validateServiceRecord(ServiceRecord srvRecord) {
        DataElement protocolDescriptor = srvRecord.getAttributeValue(4);
        if (protocolDescriptor == null || protocolDescriptor.getDataType() != 48) {
            throw new IllegalArgumentException("ProtocolDescriptorList is mandatory");
        }
        DataElement serviceClassIDList = srvRecord.getAttributeValue(1);
        if (serviceClassIDList == null || serviceClassIDList.getDataType() != 48 || serviceClassIDList.getSize() == 0) {
            throw new IllegalArgumentException("ServiceClassIDList is mandatory");
        }
        boolean isL2CAPpresent = false;
        Enumeration protocolsSeqEnum = (Enumeration)protocolDescriptor.getValue();
        while (protocolsSeqEnum.hasMoreElements()) {
            DataElement protocolElement;
            Enumeration elementSeqEnum;
            DataElement elementSeq = (DataElement)protocolsSeqEnum.nextElement();
            if (elementSeq.getDataType() != 48 || !(elementSeqEnum = (Enumeration)elementSeq.getValue()).hasMoreElements() || (protocolElement = (DataElement)elementSeqEnum.nextElement()).getDataType() != 24 || !BluetoothConsts.L2CAP_PROTOCOL_UUID.equals(protocolElement.getValue())) continue;
            isL2CAPpresent = true;
            break;
        }
        if (!isL2CAPpresent) {
            throw new IllegalArgumentException("L2CAP UUID is mandatory in ProtocolDescriptorList");
        }
    }

    protected abstract void updateStackServiceRecord(ServiceRecordImpl var1, boolean var2) throws ServiceRegistrationException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateServiceRecord(boolean acceptAndOpen) throws ServiceRegistrationException {
        if (this.serviceRecord.attributeUpdated || !acceptAndOpen) {
            try {
                this.validateServiceRecord(this.serviceRecord);
            }
            catch (IllegalArgumentException e) {
                if (acceptAndOpen) {
                    throw new ServiceRegistrationException(e.getMessage());
                }
                throw e;
            }
            try {
                this.updateStackServiceRecord(this.serviceRecord, acceptAndOpen);
            }
            finally {
                this.serviceRecord.attributeUpdated = false;
            }
        }
        if (this.serviceRecord.deviceServiceClasses != this.serviceRecord.deviceServiceClassesRegistered && (this.bluetoothStack.getFeatureSet() & 4) != 0) {
            this.bluetoothStack.setLocalDeviceServiceClasses(ServiceRecordsRegistry.getDeviceServiceClasses());
            this.serviceRecord.deviceServiceClassesRegistered = this.serviceRecord.deviceServiceClasses;
        }
    }
}

