/*
 * Decompiled with CFR 0.152.
 */
package lejos.util;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import lejos.nxt.Button;
import lejos.nxt.LCD;
import lejos.nxt.Sound;
import lejos.nxt.comm.Bluetooth;
import lejos.nxt.comm.NXTConnection;
import lejos.nxt.comm.USB;

public class Datalogger {
    private float[] log;
    private int _indx = 0;
    private int _size;

    public Datalogger() {
        this(512);
    }

    public Datalogger(int size) {
        this._size = size;
        this.log = new float[size];
    }

    public void writeLog(float v) {
        if (this._indx < this._size) {
            this.log[this._indx] = v;
            ++this._indx;
        }
    }

    public void reset() {
        this._indx = 0;
    }

    public void transmit() {
        NXTConnection connection = null;
        DataOutputStream dataOut = null;
        InputStream is = null;
        LCD.drawString(" ESC for BT", 0, 0);
        if (8 == Button.waitForPress()) {
            LCD.clear();
            LCD.drawString("wait for BT", 0, 0);
            connection = Bluetooth.waitForConnection();
        } else {
            LCD.clear();
            LCD.drawString("wait for USB", 0, 0);
            connection = USB.waitForConnection();
        }
        try {
            is = connection.openInputStream();
            dataOut = connection.openDataOutputStream();
        }
        catch (Exception ie) {
            // empty catch block
        }
        LCD.drawString("connected", 0, 0);
        boolean more = true;
        while (more) {
            try {
                LCD.clear();
                LCD.drawString("Wait for PC", 0, 0);
                int b = 0;
                b = is.read();
                LCD.drawInt(b, 8, 1);
            }
            catch (IOException ie) {
                LCD.drawString("no connection", 0, 0);
                LCD.refresh();
            }
            LCD.clear();
            LCD.drawString("sending", 0, 0);
            LCD.drawInt(this._indx, 12, 0);
            LCD.refresh();
            try {
                dataOut.writeInt(this._indx);
                dataOut.flush();
                for (int i = 0; i < this._indx; ++i) {
                    dataOut.writeFloat(this.log[i]);
                }
                dataOut.flush();
                dataOut.close();
            }
            catch (IOException e) {
                LCD.drawString("write error", 0, 0);
                LCD.refresh();
            }
            Sound.beepSequence();
            LCD.clear();
            LCD.drawString("sent " + this._indx, 0, 0);
            LCD.drawString("Resend?", 0, 1);
            more = Button.waitForPress() < 8;
        }
        try {
            dataOut.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void transmit(boolean useUSB) {
        this.transmit();
    }
}

