/*
 * Decompiled with CFR 0.152.
 */
package lejos.rcxcomm;

import lejos.nxt.RCXLink;
import lejos.nxt.SensorPort;

public class Serial {
    private static RCXLink link;
    private static byte[] buf1;
    private static byte[] packet;
    private static boolean gotOpcode;
    private static boolean gotPacket;
    private static boolean skipping;
    private static int paramsRead;
    private static int paramsRequired;
    private static int checkSum;
    private static byte lastOpcode;

    private Serial() {
    }

    public static void setPort(SensorPort port) {
        link = new RCXLink(port);
        link.setDefaultSpeed();
        link.flush();
    }

    public static int readPacket(byte[] aBuffer) {
        if (!gotPacket) {
            return 0;
        }
        gotPacket = false;
        gotOpcode = false;
        for (int i = 0; i < paramsRequired + 1; ++i) {
            aBuffer[i] = packet[i];
        }
        return paramsRequired + 1;
    }

    public static boolean isPacketAvailable() {
        int available;
        if (gotPacket) {
            return true;
        }
        if (skipping) {
            for (available = link.bytesAvailable(); available > 0; --available) {
                Serial.readByte(buf1);
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (!Serial.headerByte(buf1[0])) continue;
                skipping = false;
                break;
            }
            if (skipping) {
                return false;
            }
            gotOpcode = false;
            available = link.bytesAvailable();
        }
        if (!gotOpcode) {
            byte op = 0;
            while (available > 1) {
                Serial.readByte(buf1);
                --available;
                op = buf1[0];
                if (Serial.headerByte(op)) continue;
                Serial.readByte(buf1);
                --available;
                if (Serial.complement(buf1[0], op)) {
                    gotOpcode = true;
                    break;
                }
                skipping = true;
                return false;
            }
            if (!gotOpcode) {
                return false;
            }
            available = link.bytesAvailable();
            Serial.packet[0] = op;
            int pq = op & 7;
            paramsRequired = 0;
            if (pq > 1 && pq < 6) {
                paramsRequired = pq;
            }
            if (pq == 7) {
                paramsRequired = 1;
            }
            paramsRead = 0;
            checkSum = op & 0xFF;
        }
        if (paramsRead < paramsRequired) {
            while (available > 1) {
                Serial.readByte(buf1);
                --available;
                byte param = buf1[0];
                Serial.readByte(buf1);
                --available;
                if (Serial.complement(buf1[0], param)) {
                    checkSum += param & 0xFF;
                } else {
                    skipping = true;
                    return false;
                }
                Serial.packet[++Serial.paramsRead] = param;
                if (paramsRead != paramsRequired) continue;
                break;
            }
            if (paramsRead != paramsRequired) {
                return false;
            }
            available = link.bytesAvailable();
        }
        if (available > 1) {
            Serial.readByte(buf1);
            --available;
            byte checkDigit = buf1[0];
            Serial.readByte(buf1);
            --available;
            if (Serial.complement(buf1[0], checkDigit) && (checkDigit & 0xFF) == (checkSum & 0xFF)) {
                gotPacket = true;
                lastOpcode = packet[0];
            } else {
                skipping = true;
            }
        }
        return gotPacket;
    }

    public static boolean sendPacket(byte[] aBuffer, int aOffset, int aLen) {
        Serial.sleep();
        link.defineAndRun(aBuffer, aLen);
        Serial.sleep();
        return true;
    }

    public static void setRangeLong() {
        link.setRangeLong();
    }

    public static void setRangeShort() {
        link.setRangeLong();
    }

    public static void resetSerial() {
    }

    public static void waitTillSent() {
    }

    public static RCXLink getLink() {
        return link;
    }

    private static void sleep() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static boolean headerByte(byte b) {
        return b == 85 || b == -1 || b == 0;
    }

    private static void readByte(byte[] b) {
        b[0] = 0;
        link.readBytes(b);
    }

    private static boolean complement(byte b1, byte b2) {
        return (b1 & 0xFF) + (b2 & 0xFF) == 255;
    }

    static {
        buf1 = new byte[1];
        packet = new byte[32];
        gotOpcode = false;
        gotPacket = false;
        skipping = false;
        lastOpcode = 0;
    }
}

