/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt;

import lejos.nxt.I2CPort;
import lejos.nxt.I2CSensor;

public class UltrasonicSensor
extends I2CSensor {
    private static final byte MODE = 65;
    private static final byte DISTANCE = 66;
    private static final byte FACTORY_DATA = 17;
    private static final byte UNITS = 20;
    private static final byte CALIBRATION = 74;
    private static final byte PING_INTERVAL = 64;
    private static final byte MODE_OFF = 0;
    private static final byte MODE_SINGLE = 1;
    private static final byte MODE_CONTINUOUS = 2;
    private static final byte MODE_CAPTURE = 3;
    private static final byte MODE_RESET = 4;
    private static final int DELAY_CMD = 5;
    private static final int DELAY_AVAILABLE = 15;
    private byte[] buf = new byte[1];
    private byte[] inBuf = new byte[8];
    private String units = null;
    private int nextCmdTime;
    private int dataAvailableTime;
    private int currentDistance;
    private byte mode;

    private int now() {
        return (int)System.currentTimeMillis();
    }

    private void wait(int when) {
        int delay = when - this.now();
        if (delay > 0) {
            try {
                Thread.sleep(delay);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int getData(int register, byte[] buf, int len) {
        this.wait(this.nextCmdTime);
        int ret = super.getData(register, buf, len);
        this.nextCmdTime = this.now() + 5;
        return ret;
    }

    public int sendData(int register, byte[] buf, int len) {
        this.wait(this.nextCmdTime);
        int ret = super.sendData(register, buf, len);
        this.nextCmdTime = this.now() + 5;
        return ret;
    }

    public UltrasonicSensor(I2CPort port) {
        super(port);
        port.setType(11);
        this.mode = (byte)2;
        this.nextCmdTime = this.now() + 5;
        this.dataAvailableTime = this.now() + 15;
        this.currentDistance = 255;
    }

    public int getDistance() {
        if (this.mode == 2 && this.now() < this.dataAvailableTime) {
            return this.currentDistance;
        }
        this.wait(this.dataAvailableTime);
        int ret = this.getData(66, this.buf, 1);
        int n = this.currentDistance = ret == 0 ? this.buf[0] & 0xFF : 255;
        if (this.mode == 2) {
            this.dataAvailableTime = this.now() + 15;
        }
        return this.currentDistance;
    }

    public int getDistances(int[] dist) {
        if (dist.length < this.inBuf.length || this.mode != 1) {
            return -1;
        }
        this.wait(this.dataAvailableTime);
        int ret = this.getData(66, this.inBuf, this.inBuf.length);
        for (int i = 0; i < this.inBuf.length; ++i) {
            dist[i] = this.inBuf[i] & 0xFF;
        }
        return ret;
    }

    private int setMode(byte mode) {
        this.buf[0] = mode;
        int ret = this.sendData(65, this.buf, 1);
        this.dataAvailableTime = this.now() + 15;
        if (ret == 0) {
            this.mode = mode;
        }
        return ret;
    }

    public int ping() {
        return this.setMode((byte)1);
    }

    public int continuous() {
        return this.setMode((byte)2);
    }

    public int off() {
        return this.setMode((byte)0);
    }

    public int capture() {
        return this.setMode((byte)3);
    }

    public int reset() {
        int ret = this.setMode((byte)4);
        if (ret == 0) {
            this.mode = (byte)2;
        }
        return ret;
    }

    private int getMultiBytes(int reg, byte[] data, int len) {
        for (int i = 0; i < len; ++i) {
            int ret = this.getData(reg + i, this.buf, 1);
            if (ret != 0) {
                return ret;
            }
            data[i] = this.buf[0];
        }
        return 0;
    }

    private int setMultiBytes(int reg, byte[] data, int len) {
        for (int i = 0; i < len; ++i) {
            this.buf[0] = data[i];
            int ret = this.sendData(reg + i, this.buf, 1);
            if (ret == 0) continue;
            return ret;
        }
        return 0;
    }

    public int getFactoryData(byte[] data) {
        if (data.length < 3) {
            return -1;
        }
        return this.getMultiBytes(17, data, 3);
    }

    public String getUnits() {
        int ret = this.getData(20, this.inBuf, 7);
        if (ret != 0) {
            return this.BLANK;
        }
        char[] charBuff = new char[7];
        for (int i = 0; i < 7; ++i) {
            charBuff[i] = (char)this.inBuf[i];
        }
        this.units = new String(charBuff, 0, 7);
        return this.units;
    }

    public int getCalibrationData(byte[] data) {
        if (data.length < 3) {
            return -1;
        }
        return this.getMultiBytes(74, data, 3);
    }

    public int setCalibrationData(byte[] data) {
        if (data.length < 3) {
            return -1;
        }
        return this.setMultiBytes(74, data, 3);
    }

    public byte getContinuousInterval() {
        int ret = this.getData(64, this.buf, 1);
        return ret == 0 ? this.buf[0] : (byte)-1;
    }

    public int setContinuousInterval(byte interval) {
        this.buf[0] = interval;
        int ret = this.sendData(64, this.buf, 1);
        return ret;
    }

    public byte getMode() {
        int ret = this.getData(65, this.buf, 1);
        return ret == 0 ? this.buf[0] : (byte)-1;
    }
}

