/*
 * Decompiled with CFR 0.152.
 */
package lejos.navigation;

import lejos.navigation.CompassPilot;
import lejos.navigation.TachoNavigator;
import lejos.nxt.CompassSensor;
import lejos.nxt.Motor;
import lejos.nxt.SensorPort;

public class CompassNavigator
extends TachoNavigator {
    private CompassPilot compassPilot;

    public CompassNavigator(SensorPort compassPort, float wheelDiameter, float trackWidth, Motor leftMotor, Motor rightMotor) {
        this(compassPort, wheelDiameter, trackWidth, leftMotor, rightMotor, false);
    }

    public CompassNavigator(SensorPort compassPort, float wheelDiameter, float trackWidth, Motor leftMotor, Motor rightMotor, boolean reverse) {
        this(new CompassSensor(compassPort), wheelDiameter, trackWidth, leftMotor, rightMotor, reverse);
    }

    public CompassNavigator(CompassSensor compass, float wheelDiameter, float trackWidth, Motor leftMotor, Motor rightMotor, boolean reverse) {
        super(new CompassPilot(compass, wheelDiameter, trackWidth, leftMotor, rightMotor, reverse));
        this.compassPilot = (CompassPilot)this._pilot;
        this._heading = this.getAngle();
    }

    public CompassNavigator(CompassPilot compassPilot) {
        super(compassPilot);
        this.compassPilot = compassPilot;
        this._heading = this.getAngle();
    }

    CompassPilot getCompassPilot() {
        return this.compassPilot;
    }

    public void calibrateCompass() {
        this.compassPilot.calibrate();
    }

    public void rotateTo(float angle, boolean immediateReturn) {
        this.compassPilot.rotateTo((int)angle, false);
        if (immediateReturn) {
            return;
        }
        while (this.compassPilot.isRotating()) {
            Thread.yield();
        }
        this.updateHeading();
    }

    public void rotate(float angle, boolean immediateReturn) {
        this.compassPilot.rotate((int)angle, immediateReturn);
        this.updateHeading();
    }

    public void travel(float distance, boolean immediateReturn) {
        this.compassPilot.resetTachoCount();
        this.compassPilot.travel(distance, immediateReturn);
        if (immediateReturn) {
            return;
        }
        while (this.compassPilot.isTraveling()) {
            Thread.yield();
        }
        this.updateXY();
    }

    public void stop() {
        this.compassPilot.stop();
        this.updateXY();
    }

    public void updateHeading() {
        this._heading = (int)this.compassPilot.compass.getDegreesCartesian();
    }

    public void updateXY() {
        this.updateHeading();
        float angle = (float)Math.toRadians(this._heading);
        float dx = this.compassPilot.getTravelDistance() * (float)Math.cos(angle);
        float dy = this.compassPilot.getTravelDistance() * (float)Math.sin(angle);
        this.setPosition(dx + this.getX(), dy + this.getY(), this._heading);
    }
}

