/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Screen;

public class TextBox
extends Screen {
    private final char[][] keyboard = new char[][]{{'q', 'w', 'e', 'r', 't', 'y', 'u', 'i', 'o', 'p'}, {'a', 's', 'd', 'f', 'g', 'h', 'j', 'k', 'l', '\b'}, {'\u0005', 'z', 'x', 'c', 'v', 'b', 'n', 'm', ',', '\r'}, {' ', ' ', ' ', ' ', ' ', ' ', '-', '!', '.', ' '}, {'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P'}, {'A', 'S', 'D', 'F', 'G', 'H', 'J', 'K', 'L', '\b'}, {'\u0005', 'Z', 'X', 'C', 'V', 'B', 'N', 'M', ';', '\r'}, {' ', ' ', ' ', ' ', ' ', ' ', '-', '!', '.', ' '}, {'(', ')', '\"', '+', '*', '1', '2', '3', '@', '_'}, {'<', '>', '\'', '-', '/', '4', '5', '6', '#', '\b'}, {'[', ']', '^', '|', '=', '7', '8', '9', '~', '\r'}, {' ', ' ', ' ', ' ', ' ', ' ', '0', '%', '&', '$'}};
    private final Image digits = new Image(8, 8, new byte[]{2, 31, 100, 82, 76, -88, -88, 80});
    private final Image chars = new Image(8, 8, new byte[]{14, 5, 14, 124, 84, 104, -112, -112});
    private String text;
    private int maxSize;
    private int constraints;
    private char[] inputText = new char[16];
    private int inputIdx = 0;
    private int kSel;
    private int xSel;
    private int ySel;

    public TextBox(String title, String text, int maxSize, int constraints) {
        this.title = title;
        this.text = text;
        this.maxSize = maxSize;
        this.constraints = constraints;
    }

    public void setText(String text) {
        this.text = text;
        char[] caText = text.toCharArray();
        for (int i = 0; i < caText.length && i < this.inputText.length; ++i) {
            this.inputText[i] = caText[i];
        }
        this.inputIdx = caText.length;
    }

    public String getText() {
        return this.text;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public void setConstraints(int constraints) {
        this.constraints = constraints;
    }

    protected void keyPressed(int keyCode) {
        if (keyCode == 39) {
            this.xSel = (this.xSel + 1) % 10;
            this.repaint();
        } else if (keyCode == 37) {
            this.xSel = this.xSel == 0 ? 9 : this.xSel - 1;
            this.repaint();
        } else if (keyCode == 40) {
            this.ySel = (this.ySel + 1) % 4;
            this.repaint();
        } else if (keyCode == 38) {
            if (this.xSel == 0 && this.ySel == 2 && (this.kSel == 0 || this.kSel == 4)) {
                this.kSel = this.kSel == 4 ? 0 : 4;
            } else if (this.xSel == 0 && this.ySel == 3) {
                this.kSel = this.kSel == 8 ? 0 : 8;
            } else if (this.xSel == 9 && this.ySel == 1) {
                if (this.inputIdx > 0) {
                    this.inputText[--this.inputIdx] = '\u0000';
                }
            } else if (this.xSel == 9 && this.ySel == 2) {
                int i;
                this.text = new String(this.inputText, 0, this.inputIdx);
                for (i = 0; i < this.inputText.length; ++i) {
                    this.inputText[i] = '\u0000';
                }
                this.inputIdx = 0;
                for (i = 0; i < this.commands.size(); ++i) {
                    this.callCommandListener();
                }
            } else if (this.inputIdx < this.maxSize) {
                this.inputText[this.inputIdx++] = this.keyboard[this.kSel + this.ySel][this.xSel];
                if (!this.checkConstraints()) {
                    this.inputText[--this.inputIdx] = '\u0000';
                }
            }
            this.repaint();
        }
    }

    public void paint(Graphics g) {
        int line = 8;
        int ch = 6;
        if (this.title != null) {
            g.drawString(this.title, 0, 1 * line);
        }
        for (int i = 0; i < this.inputIdx && this.inputText[i] > '\u0000'; ++i) {
            g.drawChar(this.inputText[i], i * ch, 2 * line, false);
        }
        g.drawRect(0, 31, 99, 32);
        g.drawLine(0, 39, 100, 39);
        g.drawLine(0, 47, 100, 47);
        g.drawLine(0, 55, 100, 55);
        g.drawLine(9, 32, 10, 99);
        g.drawLine(20, 32, 20, 99);
        g.drawLine(30, 32, 30, 99);
        g.drawLine(40, 32, 40, 99);
        g.drawLine(50, 32, 50, 99);
        g.drawLine(60, 32, 60, 99);
        g.drawLine(70, 32, 70, 99);
        g.drawLine(80, 32, 80, 99);
        g.drawLine(90, 32, 90, 99);
        for (int x = 0; x < 10; ++x) {
            for (int y = 0; y < 4; ++y) {
                g.drawChar(this.keyboard[this.kSel + y][x], x * 10 + 2, (y + 4) * line, x == this.xSel && y == this.ySel);
            }
        }
        g.drawImage(this.kSel == 8 ? this.chars : this.digits, 1, 56, this.xSel == 0 && this.ySel == 3);
    }

    private boolean checkConstraints() {
        return this.constraints == 1;
    }
}

