/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class StringBuffer {
    char[] characters;
    int curPos = 0;
    static char[] buf = new char[16];
    static String minInt = "-2147483648";
    private static final float log10 = 2.3025851f;

    public StringBuffer() {
        this.characters = new char[20];
    }

    public StringBuffer(String aString) {
        this.characters = aString.toCharArray();
        this.curPos = aString.length();
    }

    public StringBuffer(int length) {
        this.characters = new char[length];
    }

    public StringBuffer delete(int start, int end) {
        if (start >= 0 && start < end && start < this.curPos) {
            if (end >= this.curPos) {
                end = this.curPos;
            } else {
                System.arraycopy(this.characters, end, this.characters, start, this.curPos - end);
            }
            this.curPos -= end - start;
        }
        return this;
    }

    public StringBuffer append(String s) {
        s = String.valueOf(s);
        return this.appendInternal(s);
    }

    public StringBuffer append(Object aObject) {
        return this.appendInternal(String.valueOf(aObject));
    }

    public StringBuffer append(boolean aBoolean) {
        return this.appendInternal(aBoolean ? "true" : "false");
    }

    public StringBuffer append(char aChar) {
        return this.appendInternal(new String(new char[]{aChar}, 0, 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer append(int i) {
        int charPos = buf.length;
        int sign = 0;
        if (i == Integer.MIN_VALUE) {
            return this.append(minInt);
        }
        if (i < 0) {
            sign = 45;
            i = -i;
        }
        char[] cArray = buf;
        synchronized (buf) {
            int len;
            int q;
            do {
                q = i / 10;
                int r = i - q * 10;
                StringBuffer.buf[--charPos] = (char)(48 + r);
            } while ((i = q) != 0);
            if (sign != 0) {
                StringBuffer.buf[--charPos] = sign;
            }
            if ((len = buf.length - charPos) + this.curPos > this.characters.length) {
                char[] nc = new char[this.curPos + len];
                System.arraycopy(this.characters, 0, nc, 0, this.curPos);
                this.characters = nc;
            }
            System.arraycopy(buf, charPos, this.characters, this.curPos, len);
            this.curPos += len;
            // ** MonitorExit[var6_4] (shouldn't be in output)
            return this;
        }
    }

    public StringBuffer append(long aLong) {
        return this.appendInternal("<longs not supported>");
    }

    public StringBuffer append(float aFloat) {
        try {
            this.append(aFloat, 8);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.curPos = Math.min(this.characters.length, this.curPos);
        }
        return this;
    }

    public StringBuffer append(double aDouble) {
        try {
            this.append((float)aDouble, 8);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.curPos = Math.min(this.characters.length, this.curPos);
        }
        return this;
    }

    private StringBuffer appendInternal(String s) {
        char[] sc = s.toCharArray();
        int cl = this.characters.length;
        int sl = sc.length;
        char[] nc = this.characters;
        if (sl + this.curPos > cl) {
            nc = new char[sl + this.curPos];
            System.arraycopy(this.characters, 0, nc, 0, this.curPos);
        }
        System.arraycopy(sc, 0, nc, this.curPos, sl);
        this.characters = nc;
        this.curPos += sl;
        return this;
    }

    public int indexOf(String str) {
        return this.indexOf(str, 0);
    }

    public synchronized int indexOf(String str, int fromIndex) {
        return String.indexOf(this.characters, 0, this.curPos, str.toCharArray(), 0, str.length(), fromIndex);
    }

    public int lastIndexOf(String str) {
        return this.lastIndexOf(str, this.curPos);
    }

    public synchronized int lastIndexOf(String str, int fromIndex) {
        return String.lastIndexOf(this.characters, 0, this.curPos, str.toCharArray(), 0, str.length(), fromIndex);
    }

    public String toString() {
        return new String(this.characters, 0, this.curPos);
    }

    public char charAt(int i) {
        return this.characters[i];
    }

    public void setCharAt(int i, char ch) {
        this.characters[i] = ch;
    }

    public int length() {
        return this.curPos;
    }

    public char[] getChars() {
        return this.characters;
    }

    public synchronized String substring(int start) {
        return this.substring(start, this.curPos);
    }

    public synchronized String substring(int start, int end) {
        int len = end - start;
        return new String(this.characters, start, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer append(float number, int significantDigits) {
        char[] cArray = buf;
        synchronized (buf) {
            int charPos = 0;
            int exponent = 0;
            if (number == 0.0f) {
                StringBuffer.buf[charPos++] = 48;
            } else {
                int pow;
                if (number < 0.0f) {
                    StringBuffer.buf[charPos++] = 45;
                    number = -number;
                }
                if ((pow = (int)Math.floor(Math.log(number) / 2.3025851249694824)) < -3 || pow > 6) {
                    exponent = pow;
                    number = (float)((double)number / Math.exp(2.30258509299405 * (double)exponent));
                }
                pow = (int)Math.floor(Math.log(number) / 2.3025851249694824);
                int insignificantDigits = -Math.min(0, pow);
                pow = Math.max(0, pow);
                double divisor = Math.pow(10.0, pow);
                int end = significantDigits + insignificantDigits;
                for (int i = 0; i < end; ++i) {
                    int div;
                    if (pow == -1) {
                        StringBuffer.buf[charPos++] = 46;
                    }
                    if ((div = (int)((double)number / divisor)) == 10) {
                        StringBuffer.buf[charPos++] = 49;
                        StringBuffer.buf[charPos++] = 48;
                    } else {
                        StringBuffer.buf[charPos] = (char)(div + 48);
                        ++charPos;
                    }
                    number = (float)((double)number - (double)div * divisor);
                    --pow;
                    if (number == 0.0f && (divisor /= 10.0) < 0.1) break;
                }
                while (buf[charPos - 1] == '0') {
                    --charPos;
                }
                if (buf[charPos - 1] == '.') {
                    ++charPos;
                }
                if (exponent != 0) {
                    StringBuffer.buf[charPos++] = 69;
                }
            }
            if (charPos + this.curPos > this.characters.length) {
                char[] nc = new char[this.curPos + charPos];
                System.arraycopy(this.characters, 0, nc, 0, this.curPos);
                this.characters = nc;
            }
            System.arraycopy(buf, 0, this.characters, this.curPos, charPos);
            this.curPos += charPos;
            if (exponent != 0) {
                this.append(exponent);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this;
        }
    }
}

