/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class DataInputStream
extends InputStream {
    protected InputStream in;

    public DataInputStream(InputStream in) {
        this.in = in;
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public int read() throws IOException {
        return this.in.read();
    }

    public final int read(byte[] b) throws IOException {
        return this.in.read(b, 0, b.length);
    }

    public final int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    public final boolean readBoolean() throws IOException {
        int ch = this.in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    public final byte readByte() throws IOException {
        int K = 256;
        int ch = this.in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        while (ch > 128) {
            ch -= K;
        }
        return (byte)ch;
    }

    public final short readShort() throws IOException {
        int b1;
        byte b0 = this.readByte();
        int x = b1 = this.readByte();
        x &= 0xFF;
        return (short)(x |= b0 << 8);
    }

    public final int readInt() throws IOException {
        int b3;
        byte b0 = this.readByte();
        byte b1 = this.readByte();
        byte b2 = this.readByte();
        int x = b3 = this.readByte();
        x &= 0xFF;
        x |= b2 << 8;
        x &= 0xFFFF;
        x |= b1 << 16;
        x &= 0xFFFFFF;
        return x |= b0 << 24;
    }

    public final char readChar() throws IOException {
        int ch2;
        InputStream in = this.in;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read())) < 0) {
            throw new EOFException();
        }
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public String readLine() throws IOException {
        StringBuffer strb = new StringBuffer();
        boolean endOfLine = false;
        while (!endOfLine) {
            char c = this.readChar();
            if (c == '\n') {
                endOfLine = true;
                continue;
            }
            if (c == '\uffff') {
                endOfLine = true;
                continue;
            }
            strb.append(c);
        }
        return strb.toString();
    }

    public void close() throws IOException {
        this.in.close();
    }
}

