/*
 * Decompiled with CFR 0.152.
 */
package lejos.pc.comm;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import lejos.pc.comm.BlueZException;
import lejos.pc.comm.NXTComm;
import lejos.pc.comm.NXTCommInputStream;
import lejos.pc.comm.NXTCommOutputStream;
import lejos.pc.comm.NXTInfo;

public class NXTCommBluez
implements NXTComm {
    private static final String BDADDR_ANY = "00:00:00:00:00:00";
    private int sk = -1;
    private int lenRemaining = 0;
    byte[] savedData = null;

    public NXTInfo[] search(String name, int protocol) {
        String[] btString = null;
        try {
            btString = this.search(name);
        }
        catch (BlueZException e) {
            System.err.println(e.getMessage());
        }
        if (btString == null) {
            return new NXTInfo[0];
        }
        NXTInfo[] nxts = new NXTInfo[btString.length];
        for (int i = 0; i < btString.length; ++i) {
            NXTInfo nxtInfo = new NXTInfo();
            if (btString[i] == null) {
                System.err.println("Null btString");
                return new NXTInfo[0];
            }
            int sep = btString[i].indexOf("::");
            nxtInfo.btDeviceAddress = btString[i].substring(sep + 2);
            nxtInfo.name = btString[i].substring(0, sep);
            nxtInfo.protocol = 2;
            nxtInfo.btResourceString = btString[i];
            nxts[i] = nxtInfo;
        }
        return nxts;
    }

    public void close() throws IOException {
        try {
            this.rcSocketShutdown(this.sk);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.sk != -1) {
            this.rcSocketClose(this.sk);
        }
        this.sk = -1;
    }

    public boolean open(NXTInfo nxt) {
        this.lenRemaining = 0;
        this.savedData = null;
        try {
            this.open(BDADDR_ANY, nxt.btDeviceAddress, 1);
            return true;
        }
        catch (BlueZException e) {
            System.err.println("Error from open: " + e.getMessage());
            return false;
        }
    }

    public byte[] sendRequest(byte[] request, int replyLen) throws IOException {
        byte[] lsb_msb = new byte[]{(byte)request.length, 0};
        request = this.concat(lsb_msb, request);
        this.rcSocketSend(this.sk, request);
        if (replyLen == 0) {
            return new byte[0];
        }
        byte[] data = null;
        data = this.rcSocketRecv(this.sk);
        data = this.subArray(data, 2, data.length);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open(String l_bdaddr, String r_bdaddr, int channel) throws BlueZException {
        boolean ok = false;
        try {
            this.sk = this.rcSocketCreate();
            this.rcSocketBind(this.sk, l_bdaddr);
            this.rcSocketConnect(this.sk, r_bdaddr, channel);
            ok = true;
        }
        finally {
            if (!ok && this.sk != -1) {
                try {
                    this.rcSocketClose(this.sk);
                }
                catch (IOException ioe) {}
                this.sk = -1;
            }
        }
    }

    private byte[] concat(byte[] data1, byte[] data2) {
        int l1 = data1.length;
        int l2 = data2.length;
        byte[] data = new byte[l1 + l2];
        System.arraycopy(data1, 0, data, 0, l1);
        System.arraycopy(data2, 0, data, l1, l2);
        return data;
    }

    private byte[] subArray(byte[] data, int start, int end) {
        byte[] result = new byte[end - start];
        System.arraycopy(data, start, result, 0, end - start);
        return result;
    }

    public byte[] read() throws IOException {
        int i;
        int packetLen;
        byte[] availData = this.rcSocketRecv(this.sk);
        int len = availData == null ? 0 : availData.length;
        int newLenRemaining = 0;
        if (len == 0) {
            return null;
        }
        if (len <= this.lenRemaining) {
            this.lenRemaining -= len;
            return availData;
        }
        if (this.savedData != null) {
            availData = this.concat(this.savedData, availData);
            len = availData.length;
            this.savedData = null;
        }
        while (len < 3) {
            byte[] moreData = this.rcSocketRecv(this.sk);
            if (moreData == null || moreData.length == 0) {
                return null;
            }
            availData = this.concat(availData, moreData);
            len = availData.length;
        }
        int dataLen = this.lenRemaining;
        for (i = this.lenRemaining; i < len; i += packetLen) {
            byte msb;
            byte lsb;
            if (len - i < 3) {
                this.savedData = new byte[len - i];
                for (int j = 0; j < len - i; ++j) {
                    this.savedData[j] = availData[i + j];
                }
                break;
            }
            if (i + (packetLen = ((lsb = availData[i++]) & 0xFF) + ((msb = availData[i++]) << 8)) <= len) {
                dataLen += packetLen;
                continue;
            }
            dataLen += len - i;
            newLenRemaining = packetLen - (len - i);
        }
        byte[] data = new byte[dataLen];
        for (i = 0; i < this.lenRemaining; ++i) {
            data[i] = availData[i];
        }
        int j = i;
        while (i < len - 2) {
            byte lsb = availData[i++];
            byte msb = availData[i++];
            int packetLen2 = (lsb & 0xFF) + (msb << 8);
            for (int k = 0; k < packetLen2 && i + k < len; ++k) {
                data[j++] = availData[i + k];
            }
            i += packetLen2;
        }
        this.lenRemaining = newLenRemaining;
        return data;
    }

    public int available() throws IOException {
        return 0;
    }

    public void write(byte[] data) throws IOException {
        byte[] lsb_msb = new byte[]{(byte)data.length, (byte)(data.length >> 8 & 0xFF)};
        this.rcSocketSend(this.sk, this.concat(lsb_msb, data));
    }

    public OutputStream getOutputStream() {
        return new NXTCommOutputStream(this);
    }

    public InputStream getInputStream() {
        return new NXTCommInputStream(this);
    }

    private native String[] search(String var1) throws BlueZException;

    private native int rcSocketCreate() throws BlueZException;

    private native void rcSocketBind(int var1, String var2) throws BlueZException;

    private native void rcSocketConnect(int var1, String var2, int var3) throws BlueZException;

    public native void rcSocketSend(int var1, byte[] var2) throws IOException;

    public native byte[] rcSocketRecv(int var1) throws IOException;

    private native void rcSocketShutdown(int var1) throws IOException;

    private native void rcSocketClose(int var1) throws IOException;

    static {
        System.loadLibrary("jbluez");
    }
}

