/*
 * Decompiled with CFR 0.152.
 */
package lejos.pc.tools;

import java.util.ArrayList;
import java.util.Collection;
import js.tinyvm.TinyVMException;
import lejos.pc.tools.NXJUploadCommandLineParser;
import lejos.pc.tools.NXJUploadException;
import lejos.pc.tools.ToolsLogListener;
import lejos.pc.tools.ToolsLogger;
import lejos.pc.tools.Upload;
import org.apache.commons.cli.CommandLine;

public class NXJUpload {
    private Collection<ToolsLogListener> fLogListeners;
    private NXJUploadCommandLineParser fParser = new NXJUploadCommandLineParser();
    private Upload fUpload;

    public NXJUpload() {
        this.fLogListeners = new ArrayList<ToolsLogListener>();
        this.fUpload = new Upload();
    }

    public static void main(String[] args) {
        try {
            NXJUpload instance = new NXJUpload();
            instance.addLogListener(new ToolsLogger());
            instance.run(args);
        }
        catch (Throwable t) {
            System.err.println("an error occurred: " + t.getMessage());
        }
    }

    public void run(String[] args) throws TinyVMException, NXJUploadException {
        int protocols = 0;
        CommandLine commandLine = this.fParser.parse(args);
        boolean run = commandLine.hasOption("r");
        boolean blueTooth = commandLine.hasOption("b");
        boolean usb = commandLine.hasOption("u");
        String name = commandLine.getOptionValue("n");
        String address = commandLine.getOptionValue("d");
        String fileName = commandLine.getArgs()[0];
        if (blueTooth) {
            protocols |= 2;
        }
        if (usb) {
            protocols |= 1;
        }
        this.fUpload.upload(name, address, protocols, fileName, run);
    }

    public void addLogListener(ToolsLogListener listener) {
        this.fLogListeners.add(listener);
        this.fUpload.addLogListener(listener);
    }

    public void removeLogListener(ToolsLogListener listener) {
        this.fLogListeners.remove(listener);
        this.fUpload.removeLogListener(listener);
    }
}

