/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2003      by Advanced Data Controls, Corp
 *  Copyright (C) 2004 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 *  Copyright (C) 2006 by GJ Business Division RICOH COMPANY,LTD. JAPAN
 *  Copyright (C) 2007-     by Monami Software Limited Partnership, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sys_config.c,v 1.1 2006/06/11 11:18:56 roi Exp $
 */

/*
 *    åȥƥ¸⥸塼At91sam7sѡ
 */

#include "jsp_kernel.h"
#include <at91sam7s.h>


/*interrupt mask*/
UW int_mode_table[MAX_INT_NUM]={
    0,
    0,
    0,
    0,
    0,
    0,
    SMR_US0,
    SMR_US1,
    0,
    0,
    0,
    0,
    SMR_TC0,
    SMR_TC1,
    SMR_TC2,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0
};

/*
 *  åȥƥ¸ν
 */
void
sys_initialize()
{
#if 0
    unsigned int  baud = ((MCK * 10) / (115200 * 16));
    unsigned long brgr;

    /*
     *  sys_putc ǽˤʤ褦UART
     */
    brgr = baud / 10;
    if((baud % 10) >= 5)
        brgr = (baud / 10) + 1;
    sil_wrw_mem((VP)(TADR_PIO_BASE+TOFF_PIO_PDR), (1<<9)|(1<<10));
    sil_wrw_mem((VP)(TADR_DBGU_BASE+TOFF_US_IDR), 0xFFFFFFFF);
    sil_wrw_mem((VP)(TADR_DBGU_BASE+TOFF_US_CR), US_RSTRX|US_RSTTX|US_RXDIS|US_TXDIS);
    sil_wrw_mem((VP)(TADR_DBGU_BASE+TOFF_US_BRGR), brgr);
    sil_wrw_mem((VP)(TADR_DBGU_BASE+TOFF_US_MR), 4<<9);
    sil_wrw_mem((VP)(TADR_DBGU_BASE+TOFF_US_CR), US_TXEN|US_RXEN);
#else /* patch */
#endif
}


/*
 *  åȥƥνλ
 */
void
sys_exit(void)
{
    syslog(LOG_EMERG, "End Kernel.....!");
    while(1);
}


/*
 *  åȥƥʸ
 */

void
sys_putc(char c)
{
#if 0
    if (c == '\n') {
        uart_putc('\r');
    }
    uart_putc(c);
#else /* patch */
#endif
}


/*
 *  ߥϥɥ
 *
 *  ֹ inhno γߥϥɥεưϤ inthdr ꤹ롥
 */
void
define_inh(INHNO inhno, FP inthdr)
{
    assert(inhno < MAX_INT_NUM);
#if 0
	sil_wrw_mem((VP)(TADR_AIC_BASE+TOFF_AIC_IDCR), 1<<inhno);
	sil_wrw_mem((VP)(TADR_AIC_BASE+TOFF_AIC_SVR+inhno*4), (UW)inthdr);
	sil_wrw_mem((VP)(TADR_AIC_BASE+TOFF_AIC_SMR+inhno*4), int_mode_table[inhno]);
	sil_wrw_mem((VP)(TADR_AIC_BASE+TOFF_AIC_ICCR), 1<<inhno);
	sil_wrw_mem((VP)(TADR_AIC_BASE+TOFF_AIC_IECR), 1<<inhno);
#else /* patch */
	int_table[inhno] = inthdr;
#endif
}

/*
 *  ̤γߤäν
 */
void
undef_interrupt(){
    syslog(LOG_EMERG, "Unregistered Interrupt occurs.");
    while(1);
}

#if 0
#else /* patch */
FP int_table[MAX_INT_NUM];
UW nontask_stack[NONTASK_STACK_SIZE / sizeof(UW)];
#endif
