/*
 *  TOPPERS/OSEK Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      OSEK Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2004 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 *  Copyright (C) 2004 by Witz Corporation, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

/*
 *	݊Ǘ@\
 */

#include "osek_kernel.h"
#include "interrupt.h"

/*
 *  sISRiJeS2j
 */
IsrType		runisr;

/*
 *  ݊Ǘ@\Ŏgpϐ̒`
 */

/*
 *  SuspendAllInterrupts ̃lXg
 *
 *  ̕ϐ́Cdisable_int() Ԃł̂ݕύXĂ悢D
 */
UINT8		sus_all_cnt;

/*
 *  SuspendOSInterrupts ̃lXg
 *
 *  ̕ϐ́Cset_ipl(ipl_maxisr2) Ԃł̂ݕύXĂ悢D
 *  set_ipl(ipl_maxisr2) ĂCJeS1  ISR ͓Ă邪C
 *  lɖ߂Ă烊^[Ζ͂ȂD
 */
static UINT8	sus_os_cnt;

/*
 *  SuspendOSInterrupts O̊ݗD惌x
 *
 *  ̕ϐ́Cset_ipl(ipl_maxisr2) Ԃł̂ݕύXĂ悢D܂C
 *  ̕ϐgpĂԂ́Csus_os_cnt [ɂĂD
 *  set_ipl(ipl_maxisr2) ĂJeS1  ISR ͓Ă邪C
 *  sus_os_cnt [ɂĂƂŁCJeS1  ISR ł̕ϐ
 *  ύX邱Ƃ͂ȂD
 */
static IPL	saved_ipl;

/*
 *  SuspendAllInterrupts/SuspendOSInterrupts O̎sReLXg
 *
 *  ̕ϐ́Cdisable_int ܂ set_ipl(ipl_maxisr2) Ԃł̂
 *  ύXĂ悢D܂C̕ϐgpĂԂ́Csus_all_cnt  
 *  sus_os_cnt [ɂĂDset_ipl(ipl_maxisr2) ĂJeS1
 *   ISR ͓Ă邪Csus_os_cnt [ɂĂƂŁCJeS
 *  1  ISR ł̕ϐύX邱Ƃ͂ȂD
 */
static UINT8	saved_callevel;

/*
 *  ݊Ǘ@\̏
 */
void
interrupt_initialize(void)
{
	IsrType		isrid;

	isrid = ISRID_NULL;
	sus_all_cnt = 0u;
	sus_os_cnt = 0u;
	for (isrid = 0; isrid < tnum_isr2; isrid++) {
		isrcb_lastres[isrid] = 0u;
	}
}

/*
 *  ׂĂ݂̊̋֎~iȈՔŁj
 */
void
DisableAllInterrupts(void)
{
	LOG_DISINT_ENTER();
	disable_int();
	LOG_DISINT_LEAVE();
}

/*
 *  ׂĂ݂̊̋iȈՔŁj
 */
void
EnableAllInterrupts(void)
{
	LOG_ENAINT_ENTER();
	enable_int();
	LOG_ENAINT_LEAVE();
}

/*
 *  ׂĂ݂̊̋֎~
 */
void
SuspendAllInterrupts(void)
{
	LOG_SUSALL_ENTER();
	if (sus_all_cnt == UINT8_INVALID) {
		/*
		 *  SuspendAllInterrupts JԂĂ񂾏ꍇ̑΍
		 *  iɔj
		 */
	}
	else if (sus_all_cnt == 0) {
		disable_int();
		sus_all_cnt++;
		if (sus_os_cnt == 0) {
			saved_callevel = callevel;
			callevel = TCL_NULL;
		}
	}
	else {
		sus_all_cnt++;
	}
	LOG_SUSALL_LEAVE();
}

/*
 *  ׂĂ݂̊̋
 */
void
ResumeAllInterrupts(void)
{
	LOG_RSMALL_ENTER();
	if (sus_all_cnt == 0) {
		/*
		 *  SuspendAllInterrupts Ă΂ɁCResumeAllInterrupts
		 *  Ă񂾏ꍇ̑΍iɔj
		 */
	}
	else if (sus_all_cnt == 1) {
		if (sus_os_cnt == 0) {
			callevel = saved_callevel;
		}
		sus_all_cnt--;
		enable_int();
	}
	else {
		sus_all_cnt--;
	}
	LOG_RSMALL_LEAVE();
}

/*
 *  JeS2݂̊̋֎~
 */
void
SuspendOSInterrupts(void)
{
	IPL	ipl;

	LOG_SUSOSI_ENTER();
	if (sus_os_cnt == UINT8_INVALID) {
		/*
		 *  SuspendOSInterrupts JԂĂ񂾏ꍇ̑΍
		 *  iɔj
		 */
	}
	else if (sus_os_cnt == 0) {
		ipl = current_ipl();

		/*
		 *  ł ISR2 ֎~Ă鎞͉ȂD
		 */
		if (ipl < ipl_maxisr2) {
			set_ipl(ipl_maxisr2);
		}
		sus_os_cnt++;
		saved_ipl = ipl;
		if (sus_all_cnt == 0) {
			saved_callevel = callevel;
			callevel = TCL_NULL;
		}
	}
	else {
		sus_os_cnt++;
	}
	LOG_SUSOSI_LEAVE();
}

/*
 *  JeS2݂̊̋
 */
void
ResumeOSInterrupts(void)
{
	LOG_RSMOSI_ENTER();
	if (sus_os_cnt == 0) {
		/*
		 *  SuspendOSInterrupts Ă΂ɁCResumeOSInterrupts
		 *  Ă񂾏ꍇ̑΍iɔj
		 */
	}
	else if (sus_os_cnt == 1) {
		if (sus_all_cnt == 0) {
			callevel = saved_callevel;
		}
		sus_os_cnt--;

		/*
		 *  Ƃ ISR2 ֎~Ă͉ȂD
		 */
		if (saved_ipl < ipl_maxisr2) {
			set_ipl(saved_ipl);
		}
	}
	else {
		sus_os_cnt--;
	}
	LOG_RSMOSI_LEAVE();
}
