/*
 *  TOPPERS/OSEK Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      OSEK Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2004 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 *  Copyright (C) 2004 by Witz Corporation, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

/*
 *	OSEKWCN[ht@C
 *
 *  AZũ\[Xt@CVXeRtBM[Vt@
 *  C炱̃t@CCN[h鎞́C_MACRO_ONLY `
 *  ƂŁC}N`ȊŐLqƂłD
 *
 *  ̒ŃCN[hĂt@CāC̃CN[ht@
 *  CɈˑĂȂD
 */

#ifndef _OSEK_H_
#define _OSEK_H_

/*
 *  bf[^^̒`
 */
#include <t_stddef.h>

#ifndef BASICTYPEDEFIND
#define BASICTYPEDEFIND

#ifndef _MACRO_ONLY

#ifdef _bool_
typedef _bool_				BOOL;		/* u[^ */
#else /* _bool_ */
typedef int					BOOL;		/* u[^ */
#endif /* _bool_ */

typedef	signed _int8_		INT8;		/* t8rbg */
typedef	unsigned _int8_		UINT8;		/* 8rbg */
#define UINT8_INVALID		((UINT8)(~0u))

typedef	signed _int16_		INT16;		/* t16rbg */
typedef	unsigned _int16_	UINT16;		/* 16rbg */
#define UINT16_INVALID		((UINT16)(~0u))

typedef	signed _int32_		INT32;		/* t32rbg */
typedef	unsigned _int32_	UINT32;		/* 32rbg */

#ifdef _int64_
typedef	signed _int64_		INT64;		/* t64rbg */
typedef	unsigned _int64_	UINT64;		/* 64rbg */
#endif /* _int64_ */

#endif /* _MACRO_ONLY */
#endif /* BASICTYPEDEFIND */

/*
 *  Xe[^XɊւ`
 */
#ifndef STATUSTYPEDEFINED
#define STATUSTYPEDEFINED

#ifndef _MACRO_ONLY
typedef UINT8		StatusType;			/* Xe[^X */
#endif /* _MACRO_ONLY */

#define	E_OK		((StatusType) 0)	/* I */

#endif /* STATUSTYPEDEFINED */

/*
 *  ^Ul̒`
 */
#define TRUE		((BOOL) 1)			/* ^ */
#define FALSE		((BOOL) 0)			/* U */


#endif /*_OSEK_H_*/
