/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: garbage.h,v 1.7 2003/12/20 06:51:58 takayuki Exp $
 */

// $Header: /home/CVS/configurator/base/garbage.h,v 1.7 2003/12/20 06:51:58 takayuki Exp $


#ifndef GARBAGE_H
#define GARBAGE_H

#ifdef _MSC_VER
#  pragma warning(disable:4290) //C++ 㳰λ̵뤵ޤؿ __declspec(nothrow) ǤʤȤΤɽޤ
#  pragma warning(disable:4786) //ǥХåǼ̻Ҥ255ʸڤΤƤޤ
#endif

#include "base/testsuite.h"
#include <list>


    //ưŪ֥Ȥ˴뤿ΥȢ롼
class TrashBox
{
public:
    typedef std::list<class Garbage *>::iterator Cookie;

protected:
    static TrashBox *    current_box;   //߻ѤƤ르Ȣ
    TrashBox *           previous_box;  //ΥȢο
    
    std::list<class Garbage *> garbage; //

public:
        //  ǻ
    TrashBox(void)  throw();
    ~TrashBox(void) throw();

    inline bool isValid(void) const throw()
    {   return (this != 0);   }

        //ȢäƤ르ߤ˴
    void cleanup(void);

        //ȤäƤ르Ȣ
    inline static TrashBox * getCurrentTrashBox(void) throw()
    {   return current_box;   }

        //
    inline Cookie addGarbage(class Garbage * _garbage) throw()
    {   return garbage.insert(garbage.begin(), _garbage);   }

        //߲
    void recoverGarbage(Cookie cookie) throw();


        //ưŪ˳ݤʤ
    void * operator new (size_t) throw(std::bad_alloc)
    {   throw std::bad_alloc();   }
    void * operator new (size_t, std::nothrow_t) throw()
    {   return 0;   }

    TESTSUITE_PROTOTYPE(main)
};


    //Ȣ르ߥ֥Ȥδ
class Garbage
{
private:
    class TrashBox *  assigned_box;
    TrashBox::Cookie  cookie;

public:
        //  ǻ
    Garbage(void)  throw();
    virtual ~Garbage(void) throw();

        //ꤲߤ򽦤夲
    void rescue(void) throw();
};


#endif


