#keyLabels.py
#A part of NonVisual Desktop Access (NVDA)
#This file is covered by the GNU General Public License.
#See the file COPYING for more details.
#Copyright (C) 2008-2010 James Teh <jamie@jantrid.net>, Aleksey Sadovoy <lex@onm.su>

localizedKeyLabels = {
	# Translators: This is the name of the back key found on multimedia keyboards for controlling the web-browser.
	'browserBack': _("back"),
	# Translators: This is the name of the forward key found on multimedia keyboards for controlling the web-browser.
	'browserForward': _("forward"),
	# Translators: This is the name of the refresh key found on multimedia keyboards for controlling the web-browser.
	'browserRefresh': _("refresh"),
	# Translators: This is the name of the stop key found on multimedia keyboards for controlling the web-browser.
	'browserStop': _("browser stop"),
	# Translators: This is the name of the back key found on multimedia keyboards to goto the search page of the web-browser.
	'browserSearch': _("search page"),
	# Translators: This is the name of the favorites key found on multimedia keyboards to open favorites in the web-browser.
	'browserFavorites': _("favorites"),
	# Translators: This is the name of the home key found on multimedia keyboards to goto the home page in the web-browser.
	'browserHome': _("home page"),
	# Translators: This is the name of the mute key found on multimedia keyboards to control playback volume.
	'volumeMute': _("mute"),
	# Translators: This is the name of the volume down key found on multimedia keyboards to reduce playback volume.
	'volumeDown': _("volume down"),
	# Translators: This is the name of the volume up key found on multimedia keyboards to increase playback volume.
	'volumeUp': _("volume up"),
	# Translators: This is the name of the next track key found on multimedia keyboards to skip to next track in the mediaplayer.
	'mediaNextTrack': _("next track"),
	# Translators: This is the name of the next track key found on multimedia keyboards to skip to next track in the mediaplayer.
	'mediaPrevTrack': _("previous track"),
	# Translators: This is the name of the stop key found on multimedia keyboards to stop the current playing track in the mediaplayer.
	'mediaStop': _("stop"),
	# Translators: This is the name of the play/pause key found on multimedia keyboards to play/pause the current playing track in the mediaplayer.
	'mediaPlayPause': _("play pause"),
	# Translators: This is the name of the launch email key found on multimedia keyboards to open an email client.
	'launchMail': _("email"),
	# Translators: This is the name of the launch mediaplayer key found on multimedia keyboards to launch the mediaplayer.
	'launchMediaPlayer': _("media player"),
	# Translators: This is the name of the launch custom application 1 key found on multimedia keyboards to launch a user-defined application.
	'launchApp1': _("custom application 1"),
	# Translators: This is the name of the launch custom application 2 key found on multimedia keyboards to launch a user-defined application.
	'launchApp2': _("custom application 2"),
	# Translators: This is the name of a key on the keyboard.
	'backspace': _("backspace"),
	# Translators: This is the name of a key on the keyboard.
	'capsLock': _("caps lock"),
	# Translators: This is the name of a key on the keyboard.
	'control': _("ctrl"),
	# Translators: This is the name of a key on the keyboard.
	'alt': _("alt"),
	# Translators: This is the name of a key on the keyboard.
	'shift': _("shift"),
	# Translators: This is the name of a key on the keyboard.
	'windows': _("windows"),
	# Translators: This is the name of a key on the keyboard.
	'enter': _("enter"),
	# Translators: This is the name of a key on the keyboard.
	'numpadEnter': _("numpad enter"),
	# Translators: This is the name of a key on the keyboard.
	'escape': _("escape"),
	# Translators: This is the name of a key on the keyboard.
	'space': _("space"),
	# Translators: This is the name of a key on the keyboard.
	'pageUp': _("page up"),
	# Translators: This is the name of a key on the keyboard.
	'pageDown': _("page down"),
	# Translators: This is the name of a key on the keyboard.
	'end': _("end"),
	# Translators: This is the name of a key on the keyboard.
	'home': _("home"),
	# Translators: This is the name of a key on the keyboard.
	'delete': _("delete"),
	# Translators: This is the name of a key on the keyboard.
	'numpadDelete': _("numpad delete"),
	# Translators: This is the name of a key on the keyboard.
	'leftArrow': _("left arrow"),
	# Translators: This is the name of a key on the keyboard.
	'rightArrow': _("right arrow"),
	# Translators: This is the name of a key on the keyboard.
	'upArrow': _("up arrow"),
	# Translators: This is the name of a key on the keyboard.
	'downArrow': _("down arrow"),
	# Translators: This is the name of a key on the keyboard.
	'applications': _("applications"),
	# Translators: This is the name of a key on the keyboard.
	'numLock': _("num lock"),
	# Translators: This is the name of a key on the keyboard.
	'printScreen': _("print screen"),
	# Translators: This is the name of a key on the keyboard.
	'scrollLock': _("scroll lock"),
	# Translators: This is the name of a key on the keyboard.
	'numpad4': _("numpad 4"),
	# Translators: This is the name of a key on the keyboard.
	'numpad6': _("numpad 6"),
	# Translators: This is the name of a key on the keyboard.
	'numpad8': _("numpad 8"),
	# Translators: This is the name of a key on the keyboard.
	'numpad2': _("numpad 2"),
	# Translators: This is the name of a key on the keyboard.
	'numpad9': _("numpad 9"),
	# Translators: This is the name of a key on the keyboard.
	'numpad3': _("numpad 3"),
	# Translators: This is the name of a key on the keyboard.
	'numpad1': _("numpad 1"),
	# Translators: This is the name of a key on the keyboard.
	'numpad7': _("numpad 7"),
	# Translators: This is the name of a key on the keyboard.
	'numpad5': _("numpad 5"),
	# Translators: This is the name of a key on the keyboard.
	'numpadDivide': _("numpad divide"),
	# Translators: This is the name of a key on the keyboard.
	'numpadMultiply': _("numpad multiply"),
	# Translators: This is the name of a key on the keyboard.
	'numpadMinus': _("numpad minus"),
	# Translators: This is the name of a key on the keyboard.
	'numpadPlus': _("numpad plus"),
	# Translators: This is the name of a key on the keyboard.
	'leftControl': _("left control"),
	# Translators: This is the name of a key on the keyboard.
	'rightControl': _("right control"),
	# Translators: This is the name of a key on the keyboard.
	'leftWindows': _("left windows"),
	# Translators: This is the name of a key on the keyboard.
	'leftShift': _("left shift"),
	# Translators: This is the name of a key on the keyboard.
	'rightShift': _("right shift"),
	# Translators: This is the name of a key on the keyboard.
	'leftAlt': _("left alt"),
	# Translators: This is the name of a key on the keyboard.
	'rightAlt': _("right alt"),
	# Translators: This is the name of a key on the keyboard.
	'rightWindows': _("right windows"),
	# Translators: This is the name of a key on the keyboard.
	'break': _("break"),
	# Translators: This is the name of a key on the keyboard.
	'tab': pgettext("keyLabel", "tab"),
}
