/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 http://nuts.sourceforge.jp
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.ext.xwork2.validator.validators;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.net.URL;

import nuts.core.images.ImageFactory;
import nuts.core.images.ImageWrapper;
import nuts.core.images.JavaImageWrapper;
import nuts.core.io.IOUtils;
import nuts.ext.fileupload.UploadFile;
import nuts.ext.fileupload.UploadImage;

import org.apache.commons.vfs.FileObject;

import com.opensymphony.xwork2.validator.ValidationException;
import com.opensymphony.xwork2.validator.validators.FieldValidatorSupport;

/**
 * image size field validator.
 */
public class ImageFieldValidator extends FieldValidatorSupport {

	protected ImageWrapper getImage(Object value) throws ValidationException {
		ImageWrapper img = null;
		try {
			if (value == null) {
			}
			else if (value instanceof byte[]) {
				img = ImageFactory.getInstance().makeImage((byte[])value);
			}
			else if (value instanceof InputStream) {
				byte[] data = IOUtils.toByteArray((InputStream)value);
				img = ImageFactory.getInstance().makeImage(data);
			}
			else if (value instanceof BufferedImage) {
				img = new JavaImageWrapper((BufferedImage)value);
			}
			else if (value instanceof ImageWrapper) {
				img = (ImageWrapper)value;
			}
			else if (value instanceof URL) {
				byte[] data = IOUtils.toByteArray((URL)value);
				img = ImageFactory.getInstance().makeImage(data);
			}
			else if (value instanceof File) {
				File f = (File)value;
				if (f.exists() && f.isFile()) {
					byte[] data = IOUtils.toByteArray(f);
					img = ImageFactory.getInstance().makeImage(data);
				}
			}
			else if (value instanceof FileObject) {
				FileObject f = (FileObject)value;
				if (f.exists()) {
					byte[] data = IOUtils.toByteArray(f);
					img = ImageFactory.getInstance().makeImage(data);
				}
			}
			else if (value instanceof UploadImage) {
				img = ((UploadImage)value).getImage();
			}
			else if (value instanceof UploadFile) {
				byte[] data = ((UploadFile)value).getData();
				if (data != null) {
					img = ImageFactory.getInstance().makeImage(data);
				}
			}
			else {
				throw new ValidationException("The value type of [" + getFieldName() + "] is invalid. (only RenderedImage/byte[]/File/URL/InputStream is allowed)");
			}
		}
		catch (Exception e) {
			log.warn("Failed to read image of [" + getFieldName() + "]", e);
		}
		return img;
	}
	
	/**
	 * @see com.opensymphony.xwork2.validator.Validator#validate(java.lang.Object)
	 */
	public void validate(Object object) throws ValidationException {
		Object value = getFieldValue(getFieldName(), object);

		if (value == null) {
			return;
		}
		else if (value instanceof UploadFile) {
			byte[] data;
			try {
				data = ((UploadFile)value).getData();
				if (data == null) {
					return;
				}
			}
			catch (Exception e) {
				return;
			}

			try {
				value = ImageFactory.getInstance().makeImage(data);
			}
			catch (Exception e) {
				addFieldError(getFieldName(), object);
			}
		}
		
		if (getImage(value) == null) {
			addFieldError(getFieldName(), object);
		}
	}
}
