/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 http://nuts.sourceforge.jp
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.ext.xwork2.validator.validators;

import java.util.Date;


/**
 * <!-- START SNIPPET: javadoc -->
 * 
 * Field Validator that checks if the date supplied is within a specific range.
 * 
 * <b>NOTE:</b> If no date converter is specified, XWorkBasicConverter will kick
 * in to do the date conversion, which by default using the <code>Date.SHORT</code> format using 
 * the a programmatically specified locale else falling back to the system 
 * default locale.
 * 
 * 
 * <!-- END SNIPPET: javadoc -->
 * 
 * <p/>
 *
 * <!-- START SNIPPET: parameters -->
 * <ul>
 * 		<li>fieldName - The field name this validator is validating. Required if using Plain-Validator Syntax otherwise not required</li>
 *      <li>min - the min date range. If not specified will not be checked.</li>
 *      <li>max - the max date range. If not specified will not be checked.</li>
 * </ul>
 * <!-- END SNIPPET: parameters -->
 * 
 * 
 * <pre>
 * <!-- START SNIPPET: examples -->
 *    &lt;validators>
 *    		&lt;!-- Plain Validator syntax --&gt;
 *    		&lt;validator type="date"&gt;
 *    	        &lt;param name="fieldName"&gt;birthday&lt;/param&gt;
 *              &lt;param name="min"&gt;01/01/1990&lt;/param&gt;
 *              &lt;param name="max"&gt;01/01/2000&lt;/param&gt;
 *              &lt;message&gt;Birthday must be within ${min} and ${max}&lt;/message&gt;
 *    		&lt;/validator&gt;
 *    
 *          &lt;!-- Field Validator Syntax --&gt;
 *          &lt;field name="birthday"&gt;
 *          	&lt;field-validator type="date"&gt;
 *           	    &lt;param name="min"&gt;01/01/1990&lt;/param&gt;
 *                  &lt;param name="max"&gt;01/01/2000&lt;/param&gt;
 *                  &lt;message&gt;Birthday must be within ${min} and ${max}&lt;/message&gt;
 *          	&lt;/field&gt;
 *          &lt;/field&gt;
 *    
 *    &lt;/validators&gt;
 * <!-- END SNIPPET: examples -->
 * </pre>
 * 
 */
public class DateRangeFieldValidator extends AbstractRangeValidator {

    private Date max;
    private Date min;

    /**
	 * @return the max
	 */
	public Date getMax() {
		return max;
	}

	/**
	 * @param max the max to set
	 */
	public void setMax(Date max) {
		this.max = max;
	}

	/**
	 * @return the min
	 */
	public Date getMin() {
		return min;
	}

	/**
	 * @param min the min to set
	 */
	public void setMin(Date min) {
		this.min = min;
	}

	protected Comparable getMaxComparatorValue() {
        return max;
    }

    protected Comparable getMinComparatorValue() {
        return min;
    }
}
