package nuts.ext.xwork2.util;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.ResourceBundle;

import nuts.core.lang.PrivateAccessUtils;

import com.opensymphony.xwork2.util.LocalizedTextUtil;

/**
 * Provides support for localization in XWork.
 */
public class LocalizedTextUtils extends LocalizedTextUtil {

	/**
	 * put specified bundles to com.opensymphony.xwork2.util.LocalizedTextUtil.bundlesMap
	 * @param bundles resource bundles map
	 * @throws Exception if an error occurs
	 */
	@SuppressWarnings("unchecked")
	public static void cacheResourceBundles(Map<String, ResourceBundle> bundles) throws Exception {
		synchronized (LocalizedTextUtils.class) {
			Map bundlesMap = (Map) PrivateAccessUtils.getStaticFieldValue(
				LocalizedTextUtil.class, "bundlesMap");
			bundlesMap.putAll(bundles);
		}
	}

    private static void clearMap(Class cls, Object obj, String name) throws Exception {
		Field field = cls.getDeclaredField(name);
		field.setAccessible(true);

		Map map = (Map)field.get(obj);
		synchronized (map) {
			map.clear();
		}

	}

    /**
	 * clear com.opensymphony.xwork2.util.LocalizedTextUtil.bundlesMap
	 * @throws Exception if an error occurs
	 */
	public static void clearResourceBundlesCache() throws Exception {
		synchronized (LocalizedTextUtils.class) {
			clearMap(LocalizedTextUtil.class, null, "bundlesMap");
			clearMap(LocalizedTextUtil.class, null, "messageFormats");
		}
	}
	
    /**
     * Returns a localized message for the specified key, aTextName.  Neither the key nor the
     * message is evaluated.
     *
     * @param aTextName the message key
     * @return a localized message based on the specified key, or null if no localized message can be found for it
     */
    public static String findDefaultText(String aTextName) {
    	return findDefaultText(aTextName, ContextUtils.getLocale());
    }

    /**
     * Returns a localized message for the specified key, aTextName, substituting variables from the
     * array of params into the message.  Neither the key nor the message is evaluated.
     *
     * @param aTextName the message key
     * @param params    an array of objects to be substituted into the message text
     * @return A formatted message based on the specified key, or null if no localized message can be found for it
     */
    public static String findDefaultText(String aTextName, Object[] params) {
    	return findDefaultText(aTextName, ContextUtils.getLocale(), params);
    }

	/**
	 * findDefaultTextForInt
     * @param aTextName the message key
	 * @return integer value
	 */
	public static Integer findDefaultTextForInt(String aTextName) {
		return findDefaultTextForInt(aTextName, null);
	}

	/**
	 * findDefaultTextForInt
     * @param aTextName the message key
	 * @param defaultValue default value
	 * @return integer value
	 */
	public static Integer findDefaultTextForInt(String aTextName, Integer defaultValue) {
		String s = findDefaultText(aTextName);
		return s == null ? defaultValue : Integer.parseInt(s);
	}

	/**
	 * findDefaultTextForLong
     * @param aTextName the message key
	 * @return long value
	 */
	public static Long findDefaultTextForLong(String aTextName) {
		return findDefaultTextForLong(aTextName, null);
	}

	/**
	 * findDefaultTextForLong
     * @param aTextName the message key
	 * @param defaultValue default value
	 * @return long value
	 */
	public static Long findDefaultTextForLong(String aTextName, Integer defaultValue) {
		String s = findDefaultText(aTextName);
		return s == null ? defaultValue : Long.parseLong(s);
	}

}
