/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 http://nuts.sourceforge.jp
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.ext.xwork2;

import java.util.Map;

import nuts.ext.xwork2.util.ContextUtils;

import org.apache.commons.lang.StringUtils;

import com.opensymphony.xwork2.util.ValueStack;

/**
 * TextProviderSupport
 */
public class TextProviderSupport extends com.opensymphony.xwork2.TextProviderSupport implements TextProvider {
	/**
	 * getTextAsBoolean
	 * @param name resource name
	 * @return boolean value
	 */
	public Boolean getTextAsBoolean(String name) {
		return getTextAsBoolean(name, null);
	}

	/**
	 * getTextAsBoolean
	 * @param name resource name
	 * @param defaultValue default value
	 * @return boolean value
	 */
	public Boolean getTextAsBoolean(String name, Boolean defaultValue) {
		String s = getText(name, (String)null);
		if (s == null) {
			return defaultValue;
		}
		else {
			return Boolean.parseBoolean(s);
		}
	}

	/**
	 * getTextAsInt
	 * @param name resource name
	 * @return integer value
	 */
	public Integer getTextAsInt(String name) {
		return getTextAsInt(name, null);
	}

	/**
	 * getTextAsInt
	 * @param name resource name
	 * @param defaultValue default value
	 * @return integer value
	 */
	public Integer getTextAsInt(String name, Integer defaultValue) {
		String s = getText(name, (String)null);
		if (s == null) {
			return defaultValue;
		}
		else {
			return Integer.parseInt(s);
		}
	}

	/**
	 * getTextAsLong
	 * @param name resource name
	 * @return long value
	 */
	public Long getTextAsLong(String name) {
		return getTextAsLong(name, null);
	}

	/**
	 * getTextAsLong
	 * @param name resource name
	 * @param defaultValue default value
	 * @return long value
	 */
	public Long getTextAsLong(String name, Long defaultValue) {
		String s = getText(name, (String)null);
		if (s == null) {
			return defaultValue;
		}
		else {
			return Long.parseLong(s);
		}
	}

	/**
	 * getTextAsMap
	 * @param name resource name
	 * @return map value
	 */
	public Map getTextAsMap(String name) {
		return getTextAsMap(name, null);
	}
	
	/**
	 * getTextAsMap
	 * @param name resource name
	 * @param defaultValue default value
	 * @return map value
	 */
	public Map getTextAsMap(String name, Map defaultValue) {
		Map map = defaultValue;

		String expr = getText(name, (String)null);
		if (StringUtils.isNotEmpty(expr)) {
			expr = StringUtils.strip(expr);
			if (expr.startsWith("{") && expr.endsWith("}")) {
				expr = "#" + expr;
			}
			else if (!expr.startsWith("#")) {
				expr = "#{" + expr + "}";
			}

			ValueStack vs = ContextUtils.getValueStack();
			map = (Map)vs.findValue(expr);
			if (map == null) {
				throw new RuntimeException("Incorrect collection expression: " + name + " - " + expr);
			}
		}

		return map;
	}
}
