/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 http://nuts.sourceforge.jp
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.ext.vfs.ndfs.dao;

import java.util.Date;

import nuts.core.orm.dao.QueryParameter;
import nuts.core.orm.restriction.ComparableRestriction;
import nuts.core.orm.restriction.LikeableRestriction;

/**
 * NdfsFileExample
 */
public interface NdfsFileExample extends QueryParameter {
	/**
	 * append AND
	 * @return this
	 */
	NdfsFileExample and();

	//----------------------------------------------------------------------
	// ALL exclude & include
	//----------------------------------------------------------------------
	/**
	 * excludeALL
	 * @return this
	 */
	NdfsFileExample excludeALL();

	/**
	 * includeALL
	 * @return this
	 */
	NdfsFileExample includeALL();

	//----------------------------------------------------------------------
	// column restrictions
	//----------------------------------------------------------------------
	/**
	 * @return restriction of id
	 */
	ComparableRestriction<NdfsFileExample, Long> id();

	/**
	 * @return restriction of parentId
	 */
	ComparableRestriction<NdfsFileExample, Long> parentId();

	/**
	 * @return restriction of name
	 */
	LikeableRestriction<NdfsFileExample, String> name();

	/**
	 * @return restriction of folder
	 */
	ComparableRestriction<NdfsFileExample, Boolean> folder();

	/**
	 * @return restriction of length
	 */
	ComparableRestriction<NdfsFileExample, Long> length();

	/**
	 * @return restriction of lastModified
	 */
	ComparableRestriction<NdfsFileExample, Date> lastModified();
}

