/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 http://nuts.sourceforge.jp
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.ext.vfs.ndfs;

import java.io.Serializable;
import java.util.Collection;

import nuts.ext.vfs.ndfs.dao.NdfsData;
import nuts.ext.vfs.ndfs.dao.NdfsDataDAO;
import nuts.ext.vfs.ndfs.dao.NdfsDataExample;
import nuts.ext.vfs.ndfs.dao.NdfsFile;
import nuts.ext.vfs.ndfs.dao.NdfsFileDAO;
import nuts.ext.vfs.ndfs.dao.NdfsFileExample;

import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.AbstractFileSystem;

/**
 * A Ndfs File System
 */
@SuppressWarnings({"serial", "unchecked"})
public class NdfsFileSystem extends AbstractFileSystem implements Serializable {
	protected int blockSize = 512 * 1024; //512KB
	
	protected NdfsFileDAO<NdfsFile, NdfsFileExample> fileDAO;
	protected NdfsDataDAO<NdfsData, NdfsDataExample> dataDAO;

	/**
	 * @param rootName
	 * @param fileSystemOptions
	 * @param gaoFileDAO
	 */
	protected NdfsFileSystem(FileName rootName,
			FileSystemOptions fileSystemOptions,
			NdfsFileDAO<NdfsFile, NdfsFileExample> fileDAO,
			NdfsDataDAO<NdfsData, NdfsDataExample> dataDAO) {

		super(rootName, null, fileSystemOptions);

		this.fileDAO = fileDAO;
		this.dataDAO = dataDAO;
	}

	/**
	 * @return the blockSize
	 */
	public int getBlockSize() {
		return blockSize;
	}

	/**
	 * @param blockSize the blockSize to set
	 */
	public void setBlockSize(int blockSize) {
		this.blockSize = blockSize;
	}

	protected FileObject createFile(FileName name) throws Exception {
		NdfsFileObject file = new NdfsFileObject(name, this);
		return file;
	}

	protected void addCapabilities(Collection caps) {
		caps.addAll(NdfsFileProvider.capabilities);
	}
}
