/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 http://nuts.sourceforge.jp
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.ext.struts2.views.jsp.ui;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import nuts.ext.struts2.components.Pager;

import org.apache.struts2.components.Component;
import org.apache.struts2.views.jsp.ui.AbstractUITag;

import com.opensymphony.xwork2.util.ValueStack;

/**
 * @see Pager
 */
@SuppressWarnings("serial")
public class PagerTag extends AbstractUITag {

	// attributes
	protected String command;
	protected String start;
	protected String end;
	protected String limit;
	protected String total;

	protected String nodataText;
	protected String infoTemplate;

	protected String linkSize;
	protected String linkStyle;

	protected String limitLabel;
	protected String limitName;
	protected Object limitList;
	protected String onLimitChange;

	/**
	 * @param start the start to set
	 */
	public void setStart(String start) {
		this.start = start;
	}

	/**
	 * @param end the end to set
	 */
	public void setEnd(String end) {
		this.end = end;
	}

	/**
	 * @param command the command to set
	 */
	public void setCommand(String command) {
		this.command = command;
	}

	/**
	 * @param limit the limit to set
	 */
	public void setLimit(String limit) {
		this.limit = limit;
	}

	/**
	 * @param total the total to set
	 */
	public void setTotal(String total) {
		this.total = total;
	}

	/**
	 * @param nodataText the nodataText to set
	 */
	public void setNodataText(String nodataText) {
		this.nodataText = nodataText;
	}

	/**
	 * @param infoTemplate the infoTemplate to set
	 */
	public void setInfoTemplate(String infoTemplate) {
		this.infoTemplate = infoTemplate;
	}

	/**
	 * @param linkSize the linkSize to set
	 */
	public void setLinkSize(String linkSize) {
		this.linkSize = linkSize;
	}

	/**
	 * @param linkStyle the linkStyle to set
	 */
	public void setLinkStyle(String linkStyle) {
		this.linkStyle = linkStyle;
	}

	/**
	 * @param limitLabel the limitLabel to set
	 */
	public void setLimitLabel(String limitLabel) {
		this.limitLabel = limitLabel;
	}

	/**
	 * @param limitName the limitName to set
	 */
	public void setLimitName(String limitName) {
		this.limitName = limitName;
	}

	/**
	 * @param limitList the limitList to set
	 */
	public void setLimitList(Object limitList) {
		this.limitList = limitList;
	}

	/**
	 * @param onLimitChange the onLimitChange to set
	 */
	public void setOnLimitChange(String onLimitChange) {
		this.onLimitChange = onLimitChange;
	}

	/**
	 * @see org.apache.struts2.views.jsp.ComponentTagSupport#getBean(com.opensymphony.xwork2.util.ValueStack,
	 *      javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	public Component getBean(ValueStack stack, HttpServletRequest req, HttpServletResponse res) {
		return new Pager(stack, req, res);
	}

	/**
	 * @see org.apache.struts2.views.jsp.ui.AbstractUITag#populateParams()
	 */
	protected void populateParams() {
		super.populateParams();

		Pager pager = ((Pager) component);
		pager.setCommand(command);
		pager.setStart(start);
		pager.setEnd(end);
		pager.setLimit(limit);
		pager.setTotal(total);
		pager.setNodataText(nodataText);
		pager.setInfoTemplate(infoTemplate);
		pager.setLinkSize(linkSize);
		pager.setLinkStyle(linkStyle);
		pager.setLimitLabel(limitLabel);
		pager.setLimitName(limitName);
		pager.setLimitList(limitList);
		pager.setOnLimitChange(onLimitChange);
	}

}
